/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import io.smallrye.common.constraint.Assert;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;

public final class CompoundType
extends ValueType {
    private static final VarHandle sizeHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "size", VarHandle.class, CompoundType.class, Long.TYPE);
    private static final VarHandle alignHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "align", VarHandle.class, CompoundType.class, Integer.TYPE);
    private final Tag tag;
    private final String name;
    private volatile long size;
    private volatile int align;
    private final boolean complete;
    private volatile Supplier<List<Member>> membersResolver;
    private volatile List<Member> members;
    private volatile List<Member> paddedMembers;
    private volatile Map<String, Member> membersByName;

    CompoundType(TypeSystem typeSystem, Tag tag, String name, Supplier<List<Member>> membersResolver, long size, int overallAlign) {
        super(typeSystem, Objects.hash(CompoundType.class, name, size, overallAlign));
        this.tag = tag;
        this.name = name;
        this.size = size;
        assert (Integer.bitCount(overallAlign) == 1);
        this.align = overallAlign;
        this.membersResolver = membersResolver;
        this.complete = true;
    }

    CompoundType(TypeSystem typeSystem, Tag tag, String name, Supplier<List<Member>> membersResolver) {
        super(typeSystem, Objects.hash(CompoundType.class, name, -1, -1));
        this.tag = tag;
        this.name = name;
        this.size = -1L;
        this.align = -1;
        this.membersResolver = membersResolver;
        this.complete = true;
    }

    CompoundType(TypeSystem typeSystem, Tag tag, String name) {
        super(typeSystem, Objects.hash(CompoundType.class, name, 0, 1));
        this.tag = tag;
        this.name = name;
        this.size = 0L;
        this.align = 1;
        this.complete = false;
        this.members = List.of();
        this.paddedMembers = List.of();
        this.membersByName = Map.of();
    }

    public boolean isAnonymous() {
        return this.name == null;
    }

    public String getName() {
        String name = this.name;
        return name == null ? "<anon>" : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Member> getMembers() {
        List<Member> members = this.members;
        if (members == null) {
            CompoundType compoundType = this;
            synchronized (compoundType) {
                members = this.members;
                if (members == null) {
                    members = this.members = this.membersResolver.get();
                    this.membersResolver = null;
                }
            }
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Member> getPaddedMembers() {
        List<Member> paddedMembers = this.paddedMembers;
        if (paddedMembers == null) {
            CompoundType compoundType = this;
            synchronized (compoundType) {
                paddedMembers = this.paddedMembers;
                if (paddedMembers == null) {
                    paddedMembers = new ArrayList<Member>(this.getMembers());
                    paddedMembers.sort(Comparator.naturalOrder());
                    int offs = 0;
                    ListIterator<Member> iterator = paddedMembers.listIterator();
                    TypeSystem ts = this.getTypeSystem();
                    UnsignedIntegerType u8 = ts.getUnsignedInteger8Type();
                    UnsignedIntegerType u16 = ts.getUnsignedInteger16Type();
                    UnsignedIntegerType u32 = ts.getUnsignedInteger32Type();
                    UnsignedIntegerType u64 = ts.getUnsignedInteger64Type();
                    assert (u8.getAlign() == 1);
                    assert (u16.getAlign() == 2);
                    assert (u32.getAlign() == 4);
                    assert (u64.getAlign() == 8);
                    while (iterator.hasNext()) {
                        Member member = iterator.next();
                        iterator.previous();
                        offs = this.padTo(offs, iterator, ts, u8, u16, u32, u64, member.getOffset());
                        iterator.next();
                        offs += (int)member.getType().getSize();
                    }
                    offs = this.padTo(offs, iterator, ts, u8, u16, u32, u64, (int)this.getSize());
                    assert ((long)offs == this.getSize());
                    this.paddedMembers = paddedMembers;
                }
            }
        }
        return paddedMembers;
    }

    private int padTo(int offs, ListIterator<Member> iterator, TypeSystem ts, UnsignedIntegerType u8, UnsignedIntegerType u16, UnsignedIntegerType u32, UnsignedIntegerType u64, int nextOffset) {
        int wordBytes;
        if (nextOffset >= offs + 1 && (offs & 1) != 0) {
            iterator.add(new Member("(padding)", u8, offs, 1));
            ++offs;
        }
        if (nextOffset >= offs + 2 && (offs & 2) != 0) {
            iterator.add(new Member("(padding)", u16, offs, 2));
            offs += 2;
        }
        if (nextOffset >= offs + 4 && (offs & 4) != 0) {
            iterator.add(new Member("(padding)", u32, offs, 4));
            offs += 4;
        }
        if ((wordBytes = (nextOffset & 0xFFFFFFF8) - offs) > 8) {
            iterator.add(new Member("(padding)", ts.getArrayType(u64, wordBytes >> 3), offs, 8));
            offs += wordBytes;
        } else if (wordBytes == 8) {
            iterator.add(new Member("(padding)", u64, offs, 8));
            offs += 8;
        }
        if (nextOffset >= offs + 4) {
            iterator.add(new Member("(padding)", u32, offs, 4));
            offs += 4;
        }
        if (nextOffset >= offs + 2) {
            iterator.add(new Member("(padding)", u16, offs, 2));
            offs += 2;
        }
        if (nextOffset >= offs + 1) {
            iterator.add(new Member("(padding)", u8, offs, 1));
            ++offs;
        }
        assert (nextOffset == offs);
        return offs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Member> getMembersByName() {
        Map<String, Member> membersByName = this.membersByName;
        if (membersByName == null) {
            CompoundType compoundType = this;
            synchronized (compoundType) {
                membersByName = this.membersByName;
                if (membersByName == null) {
                    membersByName = this.membersByName = this.createMembersByName();
                }
            }
        }
        return membersByName;
    }

    private Map<String, Member> createMembersByName() {
        List<Member> members = this.getMembers();
        Iterator<Member> iterator = members.iterator();
        if (!iterator.hasNext()) {
            return Map.of();
        }
        Member member0 = iterator.next();
        String name0 = member0.getName();
        if (!iterator.hasNext()) {
            return Map.of(name0, member0);
        }
        Member member1 = iterator.next();
        String name1 = member1.getName();
        if (!iterator.hasNext()) {
            return Map.of(name0, member0, name1, member1);
        }
        Member member2 = iterator.next();
        String name2 = member2.getName();
        if (!iterator.hasNext()) {
            return Map.of(name0, member0, name1, member1, name2, member2);
        }
        ArrayList<Map.Entry<String, Member>> entries = new ArrayList<Map.Entry<String, Member>>(members.size());
        entries.add(Map.entry(name0, member0));
        entries.add(Map.entry(name1, member1));
        entries.add(Map.entry(name2, member2));
        while (iterator.hasNext()) {
            Member member = iterator.next();
            entries.add(Map.entry(member.getName(), member));
        }
        return Map.ofEntries((Map.Entry[])entries.toArray(Map.Entry[]::new));
    }

    public Tag getTag() {
        return this.tag;
    }

    public int getMemberCount() {
        return this.getMembers().size();
    }

    public Member getMember(int index) throws IndexOutOfBoundsException {
        return this.getMembers().get(index);
    }

    public Member getMemberByOffset(int offset) {
        Member member;
        List<Member> list = this.getMembers();
        int size = list.size();
        int low = 0;
        int high = size - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            member = list.get(mid);
            int cmp = Integer.compare(member.getOffset(), offset);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return member;
        }
        if (low >= size) {
            return null;
        }
        member = list.get(low);
        if ((long)offset < (long)member.getOffset() + member.getType().getSize()) {
            return member;
        }
        return null;
    }

    public Member getMember(String name) {
        Assert.assertFalse((boolean)this.isAnonymous());
        Member member = this.getMembersByName().get(name);
        if (member != null) {
            return member;
        }
        throw new NoSuchElementException("No member named '" + name + "' found in " + this.toFriendlyString());
    }

    public boolean hasMember(String name) {
        Assert.assertFalse((boolean)this.isAnonymous());
        return this.getMembersByName().containsKey(name);
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public long getSize() {
        long size = this.size;
        if (size == -1L) {
            List<Member> members = this.getMembers();
            size = 0L;
            for (Member member : members) {
                size = Math.max(size, (long)member.getOffset() + member.getType().getSize());
            }
            long witness = sizeHandle.compareAndExchange(this, -1L, size);
            if (witness != -1L && witness != size) {
                throw new IllegalStateException();
            }
        }
        return size;
    }

    @Override
    public int getAlign() {
        int align = this.align;
        if (align == -1) {
            List<Member> members = this.getMembers();
            align = 1;
            for (Member member : members) {
                align = Math.max(align, member.getType().getAlign());
            }
            long witness = alignHandle.compareAndExchange(this, -1, align);
            if (witness != -1L && witness != (long)align) {
                throw new IllegalStateException();
            }
        }
        return align;
    }

    @Override
    public boolean equals(ValueType other) {
        CompoundType ct;
        return other instanceof CompoundType && this.equals(ct = (CompoundType)other);
    }

    @Override
    public ValueType getTypeAtOffset(long offset) {
        if (offset > this.getSize()) {
            return this.getTypeSystem().getVoidType();
        }
        Member member = this.getMemberByOffset((int)offset);
        if (member == null) {
            return this.getTypeSystem().getVoidType();
        }
        return member.getType().getTypeAtOffset(offset - (long)member.getOffset());
    }

    public boolean equals(CompoundType other) {
        return this == other || super.equals(other) && Objects.equals(this.name, other.name) && this.size == other.size && this.align == other.align && this.getMembers().equals(other.getMembers());
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append("compound ");
        if (this.tag != Tag.NONE) {
            b.append((Object)this.tag).append(' ');
        }
        return b.append(this.getName());
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        return b.append(this.getName());
    }

    public static Builder builder(TypeSystem typeSystem) {
        return new Builder(typeSystem);
    }

    public static enum Tag {
        NONE("untagged"),
        CLASS("class"),
        STRUCT("struct");

        private final String string;

        private Tag(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }

    public static final class Member
    implements Comparable<Member> {
        private final int hashCode;
        private final String name;
        private final ValueType type;
        private final int offset;
        private final int align;

        Member(String name, ValueType type, int offset, int align) {
            this.name = name;
            this.type = type;
            this.offset = offset;
            this.align = Math.max(align, type.getAlign());
            assert (Integer.bitCount(align) == 1);
            this.hashCode = (Objects.hash(name, type) * 19 + offset) * 19 + Integer.numberOfTrailingZeros(align);
        }

        public String getName() {
            return this.name;
        }

        public ValueType getType() {
            return this.type;
        }

        public <T extends ValueType> T getType(Class<T> expected) {
            return (T)((ValueType)expected.cast(this.getType()));
        }

        public int getOffset() {
            return this.offset;
        }

        public int getAlign() {
            return this.align;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder b) {
            this.type.toString(b).append(' ').append(this.name).append('@').append(this.offset);
            if (this.align > 1) {
                b.append(" align=").append(this.align);
            }
            return b;
        }

        public boolean equals(Object obj) {
            Member m;
            return obj instanceof Member && this.equals(m = (Member)obj);
        }

        public boolean equals(Member other) {
            return other == this || other != null && this.hashCode == other.hashCode && this.offset == other.offset && this.align == other.align && Objects.equals(this.name, other.name) && this.type.equals(other.type);
        }

        @Override
        public int compareTo(Member o) {
            int res = Integer.compare(this.offset, o.offset);
            if (res == 0) {
                res = Long.compare(o.type.getSize(), this.type.getSize());
            }
            if (res == 0) {
                res = Integer.compare(this.hashCode, o.hashCode);
            }
            return res;
        }
    }

    public static final class Builder {
        final TypeSystem typeSystem;
        Tag tag;
        String name;
        long size;
        int offset;
        int overallAlign;
        ArrayList<Member> members = new ArrayList();
        CompoundType completeType;

        Builder(TypeSystem typeSystem) {
            this.typeSystem = typeSystem;
            this.tag = Tag.NONE;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setTag(Tag tag) {
            this.tag = Objects.requireNonNull(tag);
            return this;
        }

        public Builder setOverallAlignment(int align) {
            if (align < 0) {
                throw new IllegalStateException("Align must be positive");
            }
            this.overallAlign = align;
            return this;
        }

        public Builder addNextMember(ValueType type) {
            Assert.assertTrue((this.name == null ? 1 : 0) != 0);
            return this.addNextMember("", type, type.getAlign());
        }

        public Builder addNextMember(String name, ValueType type) {
            return this.addNextMember(name, type, type.getAlign());
        }

        public Builder addNextMember(String name, ValueType type, int align) {
            int thisOffset = this.nextMemberOffset(this.offset, align);
            Member m = this.typeSystem.getCompoundTypeMember(name, type, thisOffset, align);
            this.overallAlign = Math.max(this.overallAlign, m.getAlign());
            this.offset = thisOffset + (int)type.getSize();
            this.members.add(m);
            return this;
        }

        public Member getLastAddedMember() {
            return this.members.get(this.members.size() - 1);
        }

        public int getMemberCountSoFar() {
            return this.members.size();
        }

        private int nextMemberOffset(int offset, int align) {
            return offset + (align - 1) & -align;
        }

        public CompoundType build() {
            if (this.members.isEmpty()) {
                throw new IllegalStateException("CompoundType has no members");
            }
            if (this.completeType == null) {
                int size = this.offset + (this.overallAlign - 1) & -this.overallAlign;
                this.completeType = this.typeSystem.getCompoundType(this.tag, this.name, size, this.overallAlign, () -> this.members);
            }
            return this.completeType;
        }
    }
}

