/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import org.qbicc.type.PointerType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.TypeUtil;
import org.qbicc.type.ValueType;

public final class ArrayType
extends ValueType {
    private final ValueType elementType;
    private final long elementCount;
    private final long elementSize;

    ArrayType(TypeSystem typeSystem, ValueType elementType, long elementCount) {
        super(typeSystem, (int)((long)(elementType.hashCode() * 19) + elementCount));
        this.elementType = elementType;
        this.elementCount = elementCount;
        this.elementSize = TypeUtil.alignUp(elementType.getSize(), elementType.getAlign());
    }

    @Override
    public long getSize() {
        return Math.multiplyExact(this.elementCount, this.elementSize);
    }

    public ValueType getElementType() {
        return this.elementType;
    }

    public <T extends ValueType> T getElementType(Class<T> expected) {
        return (T)((ValueType)expected.cast(this.getElementType()));
    }

    public long getElementCount() {
        return this.elementCount;
    }

    public long getElementSize() {
        return this.elementSize;
    }

    @Override
    public int getAlign() {
        return this.elementType.getAlign();
    }

    public PointerType asEquivalentPointerType() {
        return this.getElementType().getPointer();
    }

    @Override
    public boolean equals(ValueType other) {
        return other instanceof ArrayType && this.equals((ArrayType)other);
    }

    @Override
    public ValueType getTypeAtOffset(long offset) {
        if (0L <= offset && offset < this.getSize()) {
            return this.elementType.getTypeAtOffset(offset % this.elementSize);
        }
        return this.getTypeSystem().getVoidType();
    }

    public boolean equals(ArrayType other) {
        return this == other || super.equals(other) && this.elementCount == other.elementCount && this.elementType.equals(other.elementType);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.elementType.toString(super.toString(b).append("array [").append(this.elementCount).append("] of "));
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        return this.elementType.toFriendlyString(b).append('[').append(this.elementCount).append(']');
    }
}

