/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import org.qbicc.type.ClassObjectType;
import org.qbicc.type.InterfaceObjectType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;

public abstract class ArrayObjectType
extends PhysicalObjectType {
    private final ClassObjectType objectClass;

    ArrayObjectType(TypeSystem typeSystem, int hashCode, ClassObjectType objectClass) {
        super(typeSystem, hashCode);
        this.objectClass = objectClass;
    }

    @Override
    public boolean hasSuperClass() {
        return true;
    }

    @Override
    public ClassObjectType getSuperClassType() {
        return this.objectClass;
    }

    public abstract ValueType getElementType();

    @Override
    public boolean isSubtypeOf(ObjectType other) {
        return this == other || other instanceof ClassObjectType && this.isSubtypeOf((ClassObjectType)other) || other instanceof InterfaceObjectType && this.isSubtypeOf((InterfaceObjectType)other);
    }

    public boolean isSubtypeOf(ClassObjectType other) {
        return other.getSuperClassType() == null;
    }

    public boolean isSubtypeOf(InterfaceObjectType other) {
        DefinedTypeDefinition otherDef = other.getDefinition();
        if (otherDef.getContext() == otherDef.getContext().getCompilationContext().getBootstrapClassContext()) {
            return otherDef.internalPackageAndNameEquals("java/lang", "Cloneable") || otherDef.internalPackageAndNameEquals("java/io", "Serializable");
        }
        return false;
    }

    @Override
    public ObjectType getCommonSupertype(ObjectType other) {
        if (other instanceof InterfaceObjectType && this.isSubtypeOf((InterfaceObjectType)other)) {
            return other;
        }
        return this.getSuperClassType();
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.getElementType().toString(super.toString(b).append("array").append('[')).append(']');
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        return this.getElementType().toFriendlyString(b).append("[]");
    }
}

