/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.pointer;

import org.qbicc.pointer.ExecutableElementPointer;
import org.qbicc.pointer.RootPointer;
import org.qbicc.type.definition.element.StaticMethodElement;

public final class StaticMethodPointer
extends RootPointer
implements ExecutableElementPointer {
    private final StaticMethodElement staticMethod;

    StaticMethodPointer(StaticMethodElement staticMethod) {
        super(staticMethod.getType().getPointer());
        this.staticMethod = staticMethod;
    }

    public static StaticMethodPointer of(StaticMethodElement methodElement) {
        return methodElement.getOrCreateStaticMethodPointer(StaticMethodPointer::new);
    }

    @Deprecated
    public StaticMethodElement getStaticMethod() {
        return this.getExecutableElement();
    }

    @Override
    public StaticMethodElement getExecutableElement() {
        return this.staticMethod;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 19 + this.staticMethod.hashCode();
    }

    @Override
    public boolean equals(RootPointer other) {
        StaticMethodPointer smp;
        return other instanceof StaticMethodPointer && this.equals(smp = (StaticMethodPointer)other);
    }

    public boolean equals(StaticMethodPointer other) {
        return super.equals(other) && this.staticMethod == other.staticMethod;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return b.append('&').append(this.staticMethod.getEnclosingType().getInternalName()).append('#').append(this.staticMethod.getName()).append(this.staticMethod.getDescriptor());
    }

    @Override
    public boolean isNoThrow() {
        return this.getExecutableElement().hasNoModifiersOf(0x4000000);
    }

    @Override
    public boolean isNoSafePoints() {
        return this.getExecutableElement().hasNoModifiersOf(131072);
    }

    @Override
    public boolean isNoReturn() {
        return this.getExecutableElement().hasNoModifiersOf(0x2000000);
    }

    @Override
    public boolean isNoSideEffect() {
        return this.getExecutableElement().hasNoModifiersOf(0x400000);
    }

    @Override
    public <T, R> R accept(RootPointer.Visitor<T, R> visitor, T t) {
        return visitor.visit(t, this);
    }
}

