/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.pointer;

import org.qbicc.interpreter.Memory;
import org.qbicc.pointer.RootPointer;
import org.qbicc.type.definition.element.StaticFieldElement;

public final class StaticFieldPointer
extends RootPointer {
    private final StaticFieldElement staticField;

    StaticFieldPointer(StaticFieldElement staticField) {
        super(staticField.getType().getPointer());
        this.staticField = staticField;
    }

    public static StaticFieldPointer of(StaticFieldElement fieldElement) {
        return fieldElement.getOrCreatePointer(StaticFieldPointer::new);
    }

    public StaticFieldElement getStaticField() {
        return this.staticField;
    }

    @Override
    public long getRootByteOffset() {
        return this.staticField.getOffset();
    }

    @Override
    public Memory getRootMemoryIfExists() {
        return this.staticField.getEnclosingType().load().getVmClass().getStaticMemory();
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 19 + this.staticField.hashCode();
    }

    @Override
    public boolean equals(RootPointer other) {
        StaticFieldPointer sfp;
        return other instanceof StaticFieldPointer && this.equals(sfp = (StaticFieldPointer)other);
    }

    public boolean equals(StaticFieldPointer other) {
        return super.equals(other) && this.staticField == other.staticField;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return b.append('&').append(this.staticField.getEnclosingType().getInternalName()).append('#').append(this.staticField.getName());
    }

    @Override
    public <T, R> R accept(RootPointer.Visitor<T, R> visitor, T t) {
        return visitor.visit(t, this);
    }
}

