/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.pointer;

import org.qbicc.interpreter.Memory;
import org.qbicc.pointer.Pointer;
import org.qbicc.pointer.RootPointer;

public final class OffsetPointer
extends Pointer {
    private final Pointer basePointer;
    private final long offset;

    OffsetPointer(Pointer basePointer, long offset) {
        super(basePointer.getType());
        this.basePointer = basePointer;
        this.offset = offset;
    }

    public Pointer getBasePointer() {
        return this.basePointer;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public Pointer offsetByElements(long count) {
        if (count == 0L) {
            return this;
        }
        if (count + this.offset == 0L) {
            return this.basePointer;
        }
        return new OffsetPointer(this.basePointer, count + this.offset);
    }

    @Override
    public RootPointer getRootPointer() {
        return this.basePointer.getRootPointer();
    }

    @Override
    public long getRootByteOffset() {
        return this.basePointer.getRootByteOffset() + this.offset * this.basePointer.getPointeeType().getSize();
    }

    @Override
    public Memory getRootMemoryIfExists() {
        return this.basePointer.getRootMemoryIfExists();
    }

    @Override
    public String getRootSymbolIfExists() {
        return this.basePointer.getRootSymbolIfExists();
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.basePointer.toString(b.append('(')).append(')').append('+').append(this.offset);
    }

    @Override
    public <T, R> R accept(Pointer.Visitor<T, R> visitor, T t) {
        return visitor.visit(t, this);
    }
}

