/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.pointer;

import org.qbicc.pointer.RootPointer;
import org.qbicc.type.PointerType;

public final class IntegerAsPointer
extends RootPointer {
    private final long value;

    public IntegerAsPointer(PointerType type, long value) {
        super(type);
        this.value = value;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public long getRootByteOffset() {
        return this.getValue();
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 19 + Long.hashCode(this.value);
    }

    @Override
    public boolean equals(RootPointer other) {
        IntegerAsPointer imp;
        return other instanceof IntegerAsPointer && this.equals(imp = (IntegerAsPointer)other);
    }

    public boolean equals(IntegerAsPointer other) {
        return this == other || super.equals(other) && this.value == other.value;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        String hs = Long.toHexString(this.value);
        long ptrSize = this.getType().getSize();
        b.append("0x");
        int dc = ((int)ptrSize << 1) - hs.length();
        for (int i = 0; i < dc; ++i) {
            b.append('0');
        }
        return b.append(hs);
    }

    @Override
    public <T, R> R accept(RootPointer.Visitor<T, R> visitor, T t) {
        return visitor.visit(t, this);
    }
}

