/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.pointer;

import org.qbicc.pointer.ExecutableElementPointer;
import org.qbicc.pointer.RootPointer;
import org.qbicc.type.definition.element.InstanceMethodElement;

public final class InstanceMethodPointer
extends RootPointer
implements ExecutableElementPointer {
    private final InstanceMethodElement instanceMethod;

    InstanceMethodPointer(InstanceMethodElement instanceMethod) {
        super(instanceMethod.getType().getPointer());
        this.instanceMethod = instanceMethod;
    }

    public static InstanceMethodPointer of(InstanceMethodElement methodElement) {
        return methodElement.getOrCreateInstanceMethodPointer(InstanceMethodPointer::new);
    }

    @Deprecated
    public InstanceMethodElement getInstanceMethod() {
        return this.getExecutableElement();
    }

    @Override
    public InstanceMethodElement getExecutableElement() {
        return this.instanceMethod;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 19 + this.instanceMethod.hashCode();
    }

    @Override
    public boolean equals(RootPointer other) {
        InstanceMethodPointer imp;
        return other instanceof InstanceMethodPointer && this.equals(imp = (InstanceMethodPointer)other);
    }

    public boolean equals(InstanceMethodPointer other) {
        return this == other || super.equals(other) && this.instanceMethod == other.instanceMethod;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return b.append('&').append(this.instanceMethod);
    }

    @Override
    public boolean isNoThrow() {
        return this.getExecutableElement().hasNoModifiersOf(0x4000000);
    }

    @Override
    public boolean isNoSafePoints() {
        return this.getExecutableElement().hasNoModifiersOf(131072);
    }

    @Override
    public boolean isNoReturn() {
        return this.getExecutableElement().hasNoModifiersOf(0x2000000);
    }

    @Override
    public boolean isNoSideEffect() {
        return this.getExecutableElement().hasNoModifiersOf(0x400000);
    }

    @Override
    public <T, R> R accept(RootPointer.Visitor<T, R> visitor, T t) {
        return visitor.visit(t, this);
    }
}

