/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.pointer;

import org.qbicc.interpreter.Memory;
import org.qbicc.interpreter.Vm;
import org.qbicc.pointer.RootPointer;
import org.qbicc.type.definition.element.GlobalVariableElement;

public final class GlobalPointer
extends RootPointer {
    private final GlobalVariableElement globalVariable;

    GlobalPointer(GlobalVariableElement globalVariable) {
        super(globalVariable.getType().getPointer());
        this.globalVariable = globalVariable;
    }

    public static GlobalPointer of(GlobalVariableElement fieldElement) {
        return fieldElement.getOrCreatePointer(GlobalPointer::new);
    }

    public GlobalVariableElement getGlobalVariable() {
        return this.globalVariable;
    }

    @Override
    public Memory getRootMemoryIfExists() {
        return Vm.requireCurrent().getGlobal(this.globalVariable);
    }

    @Override
    public long getRootByteOffset() {
        return 0L;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 19 + this.globalVariable.hashCode();
    }

    @Override
    public boolean equals(RootPointer other) {
        GlobalPointer gp;
        return other instanceof GlobalPointer && this.equals(gp = (GlobalPointer)other);
    }

    public boolean equals(GlobalPointer other) {
        return super.equals(other) && this.globalVariable == other.globalVariable;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return b.append('&').append(this.globalVariable.getName());
    }

    @Override
    public <T, R> R accept(RootPointer.Visitor<T, R> visitor, T t) {
        return visitor.visit(t, this);
    }
}

