/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.pointer;

import org.qbicc.interpreter.Memory;
import org.qbicc.pointer.Pointer;
import org.qbicc.pointer.RootPointer;
import org.qbicc.type.ArrayType;
import org.qbicc.type.ValueType;

public final class ElementPointer
extends Pointer {
    private final Pointer arrayPointer;
    private final long index;

    public ElementPointer(Pointer arrayPointer, long index) {
        super(((ArrayType)arrayPointer.getType().getPointeeType()).getElementType().getPointer());
        this.arrayPointer = arrayPointer;
        this.index = index;
    }

    public Pointer getArrayPointer() {
        return this.arrayPointer;
    }

    public long getIndex() {
        return this.index;
    }

    public ArrayType getPointerArrayType() {
        return (ArrayType)this.arrayPointer.getType().getPointeeType();
    }

    public ValueType getArrayElementType() {
        return this.getPointerArrayType().getElementType();
    }

    @Override
    public Pointer offsetByElements(long count) {
        if (count == 0L) {
            return this;
        }
        return new ElementPointer(this.arrayPointer, this.index + count);
    }

    @Override
    public RootPointer getRootPointer() {
        return this.arrayPointer.getRootPointer();
    }

    @Override
    public long getRootByteOffset() {
        return this.arrayPointer.getRootByteOffset() + this.index * this.getArrayElementType().getSize();
    }

    @Override
    public Memory getRootMemoryIfExists() {
        return this.arrayPointer.getRootMemoryIfExists();
    }

    @Override
    public String getRootSymbolIfExists() {
        return this.arrayPointer.getRootSymbolIfExists();
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.arrayPointer.toString(b).append('[').append(this.index).append(']');
    }

    @Override
    public <T, R> R accept(Pointer.Visitor<T, R> visitor, T t) {
        return visitor.visit(t, this);
    }
}

