/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.pointer;

import org.qbicc.pointer.ExecutableElementPointer;
import org.qbicc.pointer.RootPointer;
import org.qbicc.type.definition.element.ConstructorElement;

public final class ConstructorPointer
extends RootPointer
implements ExecutableElementPointer {
    private final ConstructorElement constructor;

    ConstructorPointer(ConstructorElement constructor) {
        super(constructor.getType().getPointer());
        this.constructor = constructor;
    }

    public static ConstructorPointer of(ConstructorElement methodElement) {
        return methodElement.getOrCreatePointer(ConstructorPointer::new);
    }

    @Override
    public ConstructorElement getExecutableElement() {
        return this.constructor;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 19 + this.constructor.hashCode();
    }

    @Override
    public boolean equals(RootPointer other) {
        ConstructorPointer imp;
        return other instanceof ConstructorPointer && this.equals(imp = (ConstructorPointer)other);
    }

    public boolean equals(ConstructorPointer other) {
        return this == other || super.equals(other) && this.constructor == other.constructor;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return b.append('&').append(this.constructor.getEnclosingType().getInternalName()).append('#').append("<init>");
    }

    @Override
    public boolean isNoThrow() {
        return this.getExecutableElement().hasNoModifiersOf(0x4000000);
    }

    @Override
    public boolean isNoSafePoints() {
        return this.getExecutableElement().hasNoModifiersOf(131072);
    }

    @Override
    public boolean isNoReturn() {
        return this.getExecutableElement().hasNoModifiersOf(0x2000000);
    }

    @Override
    public boolean isNoSideEffect() {
        return this.getExecutableElement().hasNoModifiersOf(0x400000);
    }

    @Override
    public <T, R> R accept(RootPointer.Visitor<T, R> visitor, T t) {
        return visitor.visit(t, this);
    }
}

