/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.object;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Value;
import org.qbicc.object.Data;
import org.qbicc.object.DataDeclaration;
import org.qbicc.object.Function;
import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.ProgramModule;
import org.qbicc.object.ProgramObject;
import org.qbicc.object.Section;
import org.qbicc.object.SectionObject;
import org.qbicc.type.FunctionType;
import org.qbicc.type.TypeUtil;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.MemberElement;

public final class ModuleSection
extends ProgramObject
implements Comparable<ModuleSection> {
    final ProgramModule programModule;
    final Section section;
    final List<SectionObject> objects = new ArrayList<SectionObject>();
    long offset;

    ModuleSection(Section section, ValueType valueType, ProgramModule programModule) {
        super(section.getName(), valueType);
        this.section = section;
        this.programModule = programModule;
        this.offset = section.isDataOnly() ? 0L : -1L;
    }

    public Data addData(MemberElement originalElement, String name, Value value) {
        return this.addData(originalElement, name, value, value.getType().getAlign());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data addData(MemberElement originalElement, String name, Value value, int align) {
        Data obj = new Data(originalElement, this, (String)Assert.checkNotNullParam((String)"name", (Object)name), ((Value)Assert.checkNotNullParam((String)"value", (Object)value)).getType(), value);
        Map<String, ProgramObject> definedObjects = this.programModule.moduleObjects;
        ProgramModule programModule = this.programModule;
        synchronized (programModule) {
            ProgramObject existing = definedObjects.get(name);
            if (existing == null) {
                if (this.offset != -1L) {
                    long offset = TypeUtil.alignUp(this.offset, Math.max(align, obj.getValueType().getAlign()));
                    obj.initOffset(offset);
                    this.offset = offset + obj.getSize();
                }
                this.objects.add(obj);
                definedObjects.put(name, obj);
            } else if (existing instanceof DataDeclaration) {
                DataDeclaration decl = (DataDeclaration)existing;
                if (!decl.getValueType().equals(obj.getValueType())) {
                    this.programModule.clash(originalElement, name);
                } else {
                    obj.initDeclaration(decl);
                    if (this.offset != -1L) {
                        obj.initOffset(this.offset);
                        this.offset += obj.getSize();
                    }
                    this.objects.add(obj);
                    definedObjects.replace(name, decl, obj);
                }
            } else {
                this.twice(originalElement, name);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentOffset() {
        long offset;
        ProgramModule programModule = this.programModule;
        synchronized (programModule) {
            offset = this.offset;
        }
        if (offset == -1L) {
            throw new IllegalArgumentException("Not a data-only section");
        }
        return offset;
    }

    private void twice(MemberElement originalElement, String name) {
        CompilationContext ctxt = this.programModule.getTypeDefinition().getContext().getCompilationContext();
        if (originalElement != null) {
            ctxt.error((Element)originalElement, "Object '%s' defined twice", name);
        } else {
            ctxt.error("Synthetic object '%s' defined twice", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function addFunction(ExecutableElement originalElement, String name, FunctionType type) {
        if (this.section.isDataOnly()) {
            throw ModuleSection.dataOnlyException();
        }
        Function obj = new Function(originalElement, this, (String)Assert.checkNotNullParam((String)"name", (Object)name), (FunctionType)Assert.checkNotNullParam((String)"type", (Object)type), Function.getFunctionFlags(originalElement));
        Map<String, ProgramObject> definedObjects = this.programModule.moduleObjects;
        ProgramModule programModule = this.programModule;
        synchronized (programModule) {
            ProgramObject existing = definedObjects.get(name);
            if (existing == null) {
                this.objects.add(obj);
                definedObjects.put(name, obj);
                this.programModule.functions.add(obj);
            } else if (existing instanceof FunctionDeclaration) {
                FunctionDeclaration decl = (FunctionDeclaration)existing;
                if (!decl.getSymbolType().equals(obj.getSymbolType())) {
                    this.programModule.clash(originalElement, name);
                } else {
                    obj.initDeclaration(decl);
                    this.objects.add(obj);
                    definedObjects.replace(name, existing, obj);
                    this.programModule.functions.add(obj);
                }
            } else if (existing instanceof Function) {
                this.twice(originalElement, name);
            } else {
                this.programModule.clash(originalElement, name);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<SectionObject> contents() {
        ProgramModule programModule = this.programModule;
        synchronized (programModule) {
            return List.copyOf(this.objects);
        }
    }

    @Override
    public ProgramModule getProgramModule() {
        return this.programModule;
    }

    @Override
    public DataDeclaration getDeclaration() {
        return this.section.getSegmentStartDeclaration(this.programModule);
    }

    @Override
    public int compareTo(ModuleSection o) {
        return this.section.compareTo(o.section);
    }

    public Section getSection() {
        return this.section;
    }

    private static IllegalArgumentException dataOnlyException() {
        return new IllegalArgumentException("Cannot add function to data-only section");
    }
}

