/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.interpreter;

import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.interpreter.InvalidMemoryAccessException;
import org.qbicc.interpreter.VmObject;
import org.qbicc.pointer.Pointer;
import org.qbicc.type.ArrayType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.TypeType;
import org.qbicc.type.UnionType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;

public interface Memory {
    public int load8(long var1, ReadAccessMode var3);

    public int load16(long var1, ReadAccessMode var3);

    public int load32(long var1, ReadAccessMode var3);

    default public float loadFloat(long index, ReadAccessMode mode) {
        return Float.intBitsToFloat(this.load32(index, mode));
    }

    public long load64(long var1, ReadAccessMode var3);

    public VmObject loadRef(long var1, ReadAccessMode var3);

    public ValueType loadType(long var1, ReadAccessMode var3);

    public Pointer loadPointer(long var1, ReadAccessMode var3);

    default public double loadDouble(long index, ReadAccessMode mode) {
        return Double.longBitsToDouble(this.load64(index, mode));
    }

    public void store8(long var1, int var3, WriteAccessMode var4);

    public void store16(long var1, int var3, WriteAccessMode var4);

    public void store32(long var1, int var3, WriteAccessMode var4);

    default public void storeFloat(long index, float value, WriteAccessMode mode) {
        this.store32(index, Float.floatToRawIntBits(value), mode);
    }

    default public void store32(long index, long value, WriteAccessMode mode) {
        this.store32(index, (int)value, mode);
    }

    public void store64(long var1, long var3, WriteAccessMode var5);

    default public void storeDouble(long index, double value, WriteAccessMode mode) {
        this.store64(index, Double.doubleToRawLongBits(value), mode);
    }

    public void storeRef(long var1, VmObject var3, WriteAccessMode var4);

    public void storeType(long var1, ValueType var3, WriteAccessMode var4);

    public void storePointer(long var1, Pointer var3, WriteAccessMode var4);

    public int compareAndExchange8(long var1, int var3, int var4, ReadAccessMode var5, WriteAccessMode var6);

    public int compareAndExchange16(long var1, int var3, int var4, ReadAccessMode var5, WriteAccessMode var6);

    public int compareAndExchange32(long var1, int var3, int var4, ReadAccessMode var5, WriteAccessMode var6);

    public long compareAndExchange64(long var1, long var3, long var5, ReadAccessMode var7, WriteAccessMode var8);

    public VmObject compareAndExchangeRef(long var1, VmObject var3, VmObject var4, ReadAccessMode var5, WriteAccessMode var6);

    public ValueType compareAndExchangeType(long var1, ValueType var3, ValueType var4, ReadAccessMode var5, WriteAccessMode var6);

    public Pointer compareAndExchangePointer(long var1, Pointer var3, Pointer var4, ReadAccessMode var5, WriteAccessMode var6);

    default public int getAndSet8(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load8(index, readMode);
        int witness;
        while ((witness = this.compareAndExchange8(index, oldVal, value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndSet16(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load16(index, readMode);
        int witness;
        while ((witness = this.compareAndExchange16(index, oldVal, value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndSet32(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load32(index, readMode);
        int witness;
        while ((witness = this.compareAndExchange32(index, oldVal, value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public long getAndSet64(long index, long value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        long oldVal = this.load64(index, readMode);
        long witness;
        while ((witness = this.compareAndExchange64(index, oldVal, value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public VmObject getAndSetRef(long index, VmObject value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        VmObject oldVal = this.loadRef(index, readMode);
        VmObject witness;
        while ((witness = this.compareAndExchangeRef(index, oldVal, value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public ValueType getAndSetType(long index, ValueType value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        ValueType oldVal = this.loadType(index, readMode);
        ValueType witness;
        while ((witness = this.compareAndExchangeType(index, oldVal, value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public Pointer getAndSetPointer(long index, Pointer value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        Pointer oldVal = this.loadPointer(index, readMode);
        Pointer witness;
        while ((witness = this.compareAndExchangePointer(index, oldVal, value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndAdd8(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load8(index, readMode);
        int newVal;
        int witness;
        while ((witness = this.compareAndExchange8(index, oldVal, newVal = oldVal + value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndAdd16(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load16(index, readMode);
        int newVal;
        int witness;
        while ((witness = this.compareAndExchange16(index, oldVal, newVal = oldVal + value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndAdd32(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load32(index, readMode);
        int newVal;
        int witness;
        while ((witness = this.compareAndExchange32(index, oldVal, newVal = oldVal + value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public long getAndAdd64(long index, long value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        long oldVal = this.load64(index, readMode);
        long newVal;
        long witness;
        while ((witness = this.compareAndExchange64(index, oldVal, newVal = oldVal + value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndBitwiseAnd8(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load8(index, readMode);
        int newVal;
        int witness;
        while ((witness = this.compareAndExchange8(index, oldVal, newVal = oldVal & value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndBitwiseAnd16(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load16(index, readMode);
        int newVal;
        int witness;
        while ((witness = this.compareAndExchange16(index, oldVal, newVal = oldVal & value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndBitwiseAnd32(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load32(index, readMode);
        int newVal;
        while ((newVal = oldVal & value) != oldVal) {
            int witness = this.compareAndExchange32(index, oldVal, newVal, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public long getAndBitwiseAnd64(long index, long value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        long oldVal = this.load64(index, readMode);
        long newVal;
        while ((newVal = oldVal & value) != oldVal) {
            long witness = this.compareAndExchange64(index, oldVal, newVal, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndBitwiseNand8(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load8(index, readMode);
        int newVal;
        int witness;
        while ((witness = this.compareAndExchange8(index, oldVal, newVal = oldVal & ~value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndBitwiseNand16(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load16(index, readMode);
        int newVal;
        int witness;
        while ((witness = this.compareAndExchange16(index, oldVal, newVal = oldVal & ~value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndBitwiseNand32(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load32(index, readMode);
        int newVal;
        while ((newVal = oldVal & ~value) != oldVal) {
            int witness = this.compareAndExchange32(index, oldVal, newVal, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public long getAndBitwiseNand64(long index, long value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        long oldVal = this.load64(index, readMode);
        long newVal;
        while ((newVal = oldVal & (value ^ 0xFFFFFFFFFFFFFFFFL)) != oldVal) {
            long witness = this.compareAndExchange64(index, oldVal, newVal, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndBitwiseOr8(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load8(index, readMode);
        int newVal;
        int witness;
        while ((witness = this.compareAndExchange8(index, oldVal, newVal = oldVal | value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndBitwiseOr16(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load16(index, readMode);
        int newVal;
        int witness;
        while ((witness = this.compareAndExchange16(index, oldVal, newVal = oldVal | value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndBitwiseOr32(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load32(index, readMode);
        int newVal;
        while ((newVal = oldVal | ~value) != oldVal) {
            int witness = this.compareAndExchange32(index, oldVal, newVal, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public long getAndBitwiseOr64(long index, long value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        long oldVal = this.load64(index, readMode);
        long newVal;
        while ((newVal = oldVal | value) != oldVal) {
            long witness = this.compareAndExchange64(index, oldVal, newVal, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndBitwiseXor8(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load8(index, readMode);
        int newVal;
        int witness;
        while ((witness = this.compareAndExchange8(index, oldVal, newVal = oldVal ^ value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndBitwiseXor16(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load16(index, readMode);
        int newVal;
        int witness;
        while ((witness = this.compareAndExchange16(index, oldVal, newVal = oldVal ^ value, readMode, writeMode)) != oldVal) {
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndBitwiseXor32(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load32(index, readMode);
        int newVal;
        while ((newVal = oldVal ^ value) != oldVal) {
            int witness = this.compareAndExchange32(index, oldVal, newVal, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public long getAndBitwiseXor64(long index, long value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        long oldVal = this.load64(index, readMode);
        long newVal;
        while ((newVal = oldVal & (value ^ 0xFFFFFFFFFFFFFFFFL)) != oldVal) {
            long witness = this.compareAndExchange64(index, oldVal, newVal, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    private int signExtend8(int val) {
        return (byte)val;
    }

    private int signExtend16(int val) {
        return (short)val;
    }

    default public int getAndSetMaxSigned8(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load8(index, readMode);
        value = this.signExtend8(value);
        while (this.signExtend8(oldVal) < value) {
            int witness = this.compareAndExchange8(index, oldVal, value, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndSetMaxSigned16(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load16(index, readMode);
        value = this.signExtend16(value);
        while (this.signExtend16(oldVal) < value) {
            int witness = this.compareAndExchange16(index, oldVal, value, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndSetMaxSigned32(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load32(index, readMode);
        while (oldVal < value) {
            int witness = this.compareAndExchange32(index, oldVal, value, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public long getAndSetMaxSigned64(long index, long value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        long oldVal = this.load64(index, readMode);
        while (oldVal < value) {
            long witness = this.compareAndExchange64(index, oldVal, value, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndSetMaxUnsigned8(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load8(index, readMode) & 0xFF;
        value &= 0xFF;
        while (oldVal < value) {
            int witness = this.compareAndExchange8(index, oldVal, value, readMode, writeMode) & 0xFF;
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndSetMaxUnsigned16(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load16(index, readMode) & 0xFFFF;
        value &= 0xFFFF;
        while (oldVal < value) {
            int witness = this.compareAndExchange16(index, oldVal, value, readMode, writeMode) & 0xFFFF;
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndSetMaxUnsigned32(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load32(index, readMode);
        while (Integer.compareUnsigned(oldVal, value) < 0) {
            int witness = this.compareAndExchange32(index, oldVal, value, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public long getAndSetMaxUnsigned64(long index, long value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        long oldVal = this.load64(index, readMode);
        while (Long.compareUnsigned(oldVal, value) < 0) {
            long witness = this.compareAndExchange64(index, oldVal, value, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndSetMinSigned8(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load8(index, readMode);
        value = this.signExtend8(value);
        while (this.signExtend8(oldVal) > value) {
            int witness = this.compareAndExchange8(index, oldVal, value, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndSetMinSigned16(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load16(index, readMode);
        value = this.signExtend16(value);
        while (this.signExtend16(oldVal) > value) {
            int witness = this.compareAndExchange16(index, oldVal, value, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndSetMinSigned32(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load32(index, readMode);
        while (oldVal > value) {
            int witness = this.compareAndExchange32(index, oldVal, value, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public long getAndSetMinSigned64(long index, long value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        long oldVal = this.load64(index, readMode);
        while (oldVal > value) {
            long witness = this.compareAndExchange64(index, oldVal, value, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndSetMinUnsigned8(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load8(index, readMode) & 0xFF;
        value &= 0xFF;
        while (oldVal > value) {
            int witness = this.compareAndExchange8(index, oldVal, value, readMode, writeMode) & 0xFF;
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndSetMinUnsigned16(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load16(index, readMode) & 0xFFFF;
        value &= 0xFFFF;
        while (oldVal > value) {
            int witness = this.compareAndExchange16(index, oldVal, value, readMode, writeMode) & 0xFFFF;
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public int getAndSetMinUnsigned32(long index, int value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        int oldVal = this.load32(index, readMode);
        while (Integer.compareUnsigned(oldVal, value) > 0) {
            int witness = this.compareAndExchange32(index, oldVal, value, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    default public long getAndSetMinUnsigned64(long index, long value, ReadAccessMode readMode, WriteAccessMode writeMode) {
        long oldVal = this.load32(index, readMode);
        while (Long.compareUnsigned(oldVal, value) > 0) {
            long witness = this.compareAndExchange64(index, oldVal, value, readMode, writeMode);
            if (witness == oldVal) {
                return oldVal;
            }
            oldVal = witness;
        }
        return oldVal;
    }

    public Memory copy(long var1);

    public Memory clone();

    public Memory cloneZeroed();

    public long getSize();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public void typedCopyTo(long srcOffs, Memory dest, long destOffs, ValueType type) {
        if (type instanceof CompoundType) {
            CompoundType ct = (CompoundType)type;
            this.typedCopyTo(srcOffs, dest, destOffs, ct);
            return;
        } else if (type instanceof UnionType) {
            UnionType ut = (UnionType)type;
            this.typedCopyTo(srcOffs, dest, destOffs, ut);
            return;
        } else if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            this.typedCopyTo(srcOffs, dest, destOffs, at);
            return;
        } else if (type instanceof ReferenceType) {
            dest.storeRef(destOffs, this.loadRef(srcOffs, AccessModes.SinglePlain), AccessModes.SinglePlain);
            return;
        } else if (type instanceof TypeType) {
            dest.storeType(destOffs, this.loadType(srcOffs, AccessModes.SinglePlain), AccessModes.SinglePlain);
            return;
        } else if (type instanceof PointerType) {
            dest.storePointer(destOffs, this.loadPointer(srcOffs, AccessModes.SinglePlain), AccessModes.SinglePlain);
            return;
        } else {
            if (!(type instanceof WordType)) throw new InvalidMemoryAccessException();
            WordType wt = (WordType)type;
            int minBits = wt.getMinBits();
            if (minBits <= 8) {
                dest.store8(destOffs, this.load8(srcOffs, AccessModes.SinglePlain), AccessModes.SinglePlain);
                return;
            } else if (minBits == 16) {
                dest.store16(destOffs, this.load16(srcOffs, AccessModes.SinglePlain), AccessModes.SinglePlain);
                return;
            } else if (minBits == 32) {
                dest.store32(destOffs, this.load32(srcOffs, AccessModes.SinglePlain), (WriteAccessMode)AccessModes.SinglePlain);
                return;
            } else {
                if (minBits != 64) throw new InvalidMemoryAccessException();
                dest.store64(destOffs, this.load64(srcOffs, AccessModes.SinglePlain), AccessModes.SinglePlain);
            }
        }
    }

    default public void typedCopyTo(long srcOffs, Memory dest, long destOffs, CompoundType type) {
        for (CompoundType.Member member : type.getMembers()) {
            int offset = member.getOffset();
            this.typedCopyTo(srcOffs + (long)offset, dest, destOffs + (long)offset, member.getType());
        }
    }

    default public void typedCopyTo(long srcOffs, Memory dest, long destOffs, UnionType type) {
        for (UnionType.Member member : type.getMembers()) {
            this.typedCopyTo(srcOffs, dest, destOffs, member.getType());
        }
    }

    default public void typedCopyTo(long srcOffs, Memory dest, long destOffs, ArrayType type) {
        ValueType elementType = type.getElementType();
        long elementCount = type.getElementCount();
        long elementTypeSize = elementType.getSize();
        for (long i = 0L; i < elementCount; ++i) {
            long offset = i * elementTypeSize;
            this.typedCopyTo(srcOffs + offset, dest, destOffs + offset, elementType);
        }
    }
}

