/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.schedule;

import io.smallrye.common.constraint.Assert;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Stream;

public final class Util {
    private Util() {
    }

    public static <E> Set<E> getCachedSet(Map<Set<E>, Set<E>> setCache, Set<E> set) {
        Set<E> appearing;
        if (set.isEmpty()) {
            return Set.of();
        }
        Set<E> cached = setCache.get(set);
        if (cached == null && (appearing = setCache.putIfAbsent(cached = Util.copyOfTrusted(set), cached)) != null) {
            cached = appearing;
        }
        return cached;
    }

    public static <E> Set<E> copyOfTrusted(Set<E> orig) {
        if (orig.isEmpty()) {
            return Set.of();
        }
        return Set.of(orig.toArray(Object[]::new));
    }

    public static <E> Set<E> setWith(Set<E> orig, E item) {
        Assert.checkNotNullParam((String)"orig", orig);
        Assert.checkNotNullParam((String)"item", item);
        if (orig.isEmpty()) {
            return Set.of(item);
        }
        if (orig.contains(item)) {
            return orig;
        }
        return new WithSet<E>(orig, item);
    }

    private static final class WithSet<E>
    extends AbstractSet<E> {
        private final E item;
        private final Set<E> orig;

        private WithSet(Set<E> orig, E item) {
            this.item = item;
            this.orig = orig;
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator<E> delegate = this.orig.iterator();
            return new Iterator<E>(){
                private E next;
                {
                    this.next = item;
                }

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    if (delegate.hasNext()) {
                        this.next = delegate.next();
                        return true;
                    }
                    return false;
                }

                @Override
                public E next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        Object e = this.next;
                        return e;
                    }
                    finally {
                        this.next = null;
                    }
                }
            };
        }

        @Override
        public int size() {
            return this.orig.size() + 1;
        }

        @Override
        public int hashCode() {
            return this.orig.hashCode() + this.item.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object other) {
            if (other == this) return true;
            if (!(other instanceof Set)) return false;
            Set set = (Set)other;
            if (this.size() != set.size()) return false;
            if (this.hashCode() != set.hashCode()) return false;
            if (!set.contains(this.item)) return false;
            if (!set.containsAll(this.orig)) return false;
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return this.item.equals(o) || this.orig.contains(o);
        }

        @Override
        public Stream<E> stream() {
            return Stream.concat(Stream.of(this.item), this.orig.stream());
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(Object[]::new);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length >= this.size()) {
                return this.toArray(ignored -> a);
            }
            return this.toArray(size -> Arrays.copyOf(a, size));
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> generator) {
            int size = this.size();
            T[] array = this.orig.toArray(generator.apply(size));
            array[size - 1] = this.item;
            return array;
        }
    }
}

