/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.schedule;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.Invoke;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.PinnedNode;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.Unschedulable;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.schedule.BlockInfo;
import org.qbicc.graph.schedule.DominatorFinder;
import org.qbicc.graph.schedule.Util;

public final class Scheduler {
    private final Mode mode;

    public Scheduler(Mode mode) {
        this.mode = (Mode)((Object)Assert.checkNotNullParam((String)"mode", (Object)((Object)mode)));
    }

    public void schedule(BasicBlock entryBlock) {
        new Context((BasicBlock)Assert.checkNotNullParam((String)"entryBlock", (Object)entryBlock)).run();
    }

    public static enum Mode {
        EARLY,
        LATE;

    }

    private final class Context {
        private final BasicBlock entryBlock;
        private final BlockInfo rootBlock;
        private final BlockInfo[] allBlocks;
        private final Map<BasicBlock, BlockInfo> blockInfos;
        private final Map<Node, BlockInfo> earliestMapping = new HashMap<Node, BlockInfo>();
        private final Map<Node, BlockInfo> lateMapping = new HashMap<Node, BlockInfo>();
        private final Map<Node, Set<Node>> dependents = new HashMap<Node, Set<Node>>();
        private final Map<Set<Value>, Set<Value>> valueSetCache = new HashMap<Set<Value>, Set<Value>>();

        Context(BasicBlock entryBlock) {
            this.entryBlock = entryBlock;
            int[] indexHolder = new int[]{2};
            HashMap<BasicBlock, BlockInfo> blockInfos = new HashMap<BasicBlock, BlockInfo>();
            BlockInfo root = new BlockInfo(entryBlock, 1);
            root.computeIndices(blockInfos, indexHolder);
            int maxOneBasedIndex = indexHolder[0];
            BlockInfo[] allBlocks = new BlockInfo[maxOneBasedIndex - 1];
            for (Map.Entry entry : blockInfos.entrySet()) {
                BlockInfo blockInfo;
                allBlocks[blockInfo.index - 1] = blockInfo = (BlockInfo)entry.getValue();
                ((BasicBlock)entry.getKey()).setIndex(blockInfo.index);
            }
            this.blockInfos = blockInfos;
            this.rootBlock = root;
            this.allBlocks = allBlocks;
        }

        void run() {
            Map<Node, BlockInfo> scheduleToUse;
            new DominatorFinder(this.allBlocks).main();
            for (BlockInfo block : this.allBlocks) {
                block.findDomDepths(this.allBlocks);
            }
            this.scheduleEarly();
            if (Scheduler.this.mode == Mode.LATE) {
                this.scheduleLate();
                scheduleToUse = this.lateMapping;
            } else {
                scheduleToUse = this.earliestMapping;
            }
            for (Map.Entry<Node, BlockInfo> entry : scheduleToUse.entrySet()) {
                entry.getKey().setScheduledBlock(entry.getValue().block);
            }
            this.buildSequence();
        }

        private void scheduleEarly() {
            this.scheduleEarly(this.entryBlock);
        }

        private BlockInfo scheduleEarly(BasicBlock block) {
            return this.scheduleEarly(block.getTerminator());
        }

        private BlockInfo scheduleDependenciesEarly(Node node) {
            BlockInfo candidate;
            BlockInfo selected = this.rootBlock;
            int cnt = node.getValueDependencyCount();
            for (int i = 0; i < cnt; ++i) {
                Value valueDependency = node.getValueDependency(i);
                candidate = this.scheduleEarly(node, valueDependency);
                if (candidate.domDepth <= selected.domDepth) continue;
                selected = candidate;
            }
            if (node instanceof OrderedNode) {
                OrderedNode on = (OrderedNode)node;
                Node dependency = on.getDependency();
                candidate = this.scheduleEarly(on, dependency);
                if (candidate.domDepth > selected.domDepth) {
                    selected = candidate;
                }
                if (node instanceof Terminator) {
                    Terminator t = (Terminator)node;
                    for (Slot slot : t.getOutboundArgumentNames()) {
                        this.scheduleEarly(t, t.getOutboundArgument(slot));
                    }
                }
            }
            return selected;
        }

        private BlockInfo scheduleEarly(Node dependentNode, Node dependencyNode) {
            if (!(dependencyNode instanceof Unschedulable)) {
                this.dependents.computeIfAbsent(dependencyNode, Context::newSet).add(dependentNode);
            }
            return this.scheduleEarly(dependencyNode);
        }

        private BlockInfo scheduleEarly(Node node) {
            BlockInfo selected = this.earliestMapping.get(node);
            if (selected != null) {
                return selected;
            }
            if (node instanceof PinnedNode) {
                PinnedNode pn = (PinnedNode)node;
                return this.scheduleEarlyToPinnedBlock(pn, pn.getPinnedBlock());
            }
            if (node instanceof Terminator) {
                Terminator t = (Terminator)node;
                selected = this.scheduleEarlyToPinnedBlock(t, t.getTerminatedBlock());
                int sc = t.getSuccessorCount();
                for (int i = 0; i < sc; ++i) {
                    this.scheduleEarly(t.getSuccessor(i));
                }
                return selected;
            }
            if (node instanceof Unschedulable) {
                Unschedulable un = (Unschedulable)node;
                return this.scheduleDependenciesEarly(un);
            }
            selected = this.scheduleDependenciesEarly(node);
            this.earliestMapping.put(node, selected);
            return selected;
        }

        private BlockInfo scheduleEarlyToPinnedBlock(Node node, BasicBlock pinnedBlock) {
            BlockInfo selected = this.blockInfos.get(pinnedBlock);
            if (selected == null) {
                throw new IllegalStateException("No block selected");
            }
            this.earliestMapping.put(node, selected);
            this.scheduleDependenciesEarly(node);
            return selected;
        }

        private void scheduleLate() {
            for (Node node : this.earliestMapping.keySet()) {
                this.scheduleLate(node);
            }
        }

        private BlockInfo scheduleLate(Node node) {
            BlockInfo earliest;
            assert (node != null);
            BlockInfo selected = this.lateMapping.get(node);
            if (selected != null) {
                return selected;
            }
            if (node instanceof Unschedulable) {
                return null;
            }
            if (node instanceof Terminator) {
                Terminator t = (Terminator)node;
                earliest = this.blockInfos.get(t.getTerminatedBlock());
                this.lateMapping.put(node, earliest);
            } else if (node instanceof PinnedNode) {
                PinnedNode pn = (PinnedNode)node;
                earliest = this.blockInfos.get(pn.getPinnedBlock());
                this.lateMapping.put(node, earliest);
            } else {
                earliest = this.earliestMapping.get(node);
            }
            if (earliest == null) {
                throw new IllegalStateException();
            }
            Set dependents = this.dependents.getOrDefault(node, Set.of());
            for (Object dependent : dependents) {
                BlockInfo candidate = this.scheduleLate((Node)dependent);
                if (candidate == selected) continue;
                if (candidate == earliest) {
                    selected = earliest;
                    continue;
                }
                if (selected == null) {
                    selected = candidate;
                    continue;
                }
                while (!earliest.block.getLoops().containsAll(candidate.block.getLoops())) {
                    candidate = this.allBlocks[candidate.dominator - 1];
                }
                while (!selected.dominates(this.allBlocks, candidate)) {
                    selected = this.allBlocks[selected.dominator - 1];
                }
            }
            if (selected != null) {
                for (Object dependent : dependents) {
                    BlockInfo dependentBlock = this.scheduleLate((Node)dependent);
                    if (!selected.dominates(this.allBlocks, dependentBlock)) {
                        throw new AssertionError();
                    }
                }
            }
            if (node instanceof Terminator) {
                Terminator terminator = (Terminator)node;
                selected = earliest;
                this.lateMapping.put(node, selected);
                for (Slot slot : terminator.getOutboundArgumentNames()) {
                    this.scheduleLate(terminator.getOutboundArgument(slot));
                }
                for (int i = 0; i < terminator.getSuccessorCount(); ++i) {
                    this.scheduleLate(terminator.getSuccessor(i).getBlockEntry());
                }
            } else if (node instanceof PinnedNode) {
                selected = earliest;
            } else if (selected == null) {
                throw new IllegalStateException();
            }
            this.lateMapping.put(node, selected);
            return selected;
        }

        private void buildSequence() {
            HashMap<BasicBlock, List<Node>> blockToNodesMap = new HashMap<BasicBlock, List<Node>>(this.allBlocks.length);
            HashMap<BasicBlock, Map<Slot, BlockParameter>> blockParameters = new HashMap<BasicBlock, Map<Slot, BlockParameter>>(this.allBlocks.length);
            HashSet<Node> visited = new HashSet<Node>();
            for (BlockInfo bi : this.allBlocks) {
                BlockEntry blockEntry = bi.block.getBlockEntry();
                ArrayList<BlockEntry> list = new ArrayList<BlockEntry>();
                list.add(blockEntry);
                visited.add(blockEntry);
                blockToNodesMap.put(bi.block, list);
            }
            ArrayDeque<BlockParameter> cleanups = new ArrayDeque<BlockParameter>();
            this.buildSequence(this.entryBlock.getTerminator(), visited, blockToNodesMap, blockParameters, cleanups);
            Object bp = cleanups.pollFirst();
            while (bp != null) {
                BasicBlock bpBlock = bp.getPinnedBlock();
                for (BasicBlock incoming : bpBlock.getIncoming()) {
                    Terminator t = incoming.getTerminator();
                    Slot slot = ((BlockParameter)bp).getSlot();
                    if (!t.getOutboundArgumentNames().contains(slot)) continue;
                    Value outboundArgument = t.getOutboundArgument(slot);
                    this.buildSequence(outboundArgument, visited, blockToNodesMap, blockParameters, cleanups);
                }
                bp = cleanups.pollFirst();
            }
            for (BlockInfo bi : this.allBlocks) {
                BasicBlock block = bi.block;
                List list = (List)blockToNodesMap.get(block);
                Terminator t = block.getTerminator();
                t.setScheduleIndex(list.size());
                list.add(t);
                block.setInstructions(list);
                block.setUsedParameters(Map.copyOf(blockParameters.getOrDefault(block, Map.of())));
            }
            this.computeLiveSetsByUse();
            HashSet<Value> live = new HashSet<Value>();
            for (BlockInfo bi : this.allBlocks) {
                BasicBlock block = bi.block;
                live.clear();
                live.addAll(bi.liveOut);
                Set<Value> liveOut = Util.getCachedSet(this.valueSetCache, bi.liveOut);
                List<Node> instructions = block.getInstructions();
                ListIterator<Node> li = instructions.listIterator(instructions.size());
                while (li.hasPrevious()) {
                    BlockParameter bp2;
                    Node node = li.previous();
                    node.setLiveOuts(liveOut);
                    if (!(node instanceof BlockParameter) || (bp2 = (BlockParameter)node).getPinnedBlock() == block) {
                        // empty if block
                    }
                    if (node instanceof Value) {
                        Value v = (Value)node;
                        live.remove(v);
                    } else if (node instanceof Invoke) {
                        Invoke inv = (Invoke)node;
                        live.remove(inv.getReturnValue());
                    }
                    int cnt = node.getValueDependencyCount();
                    for (int i = 0; i < cnt; ++i) {
                        Value val = node.getValueDependency(i);
                        if (val instanceof Literal) continue;
                        live.add(val);
                    }
                    liveOut = Util.getCachedSet(this.valueSetCache, live);
                    node.setLiveIns(liveOut);
                }
            }
        }

        private void buildSequence(Node node, Set<Node> visited, Map<BasicBlock, List<Node>> sequences, Map<BasicBlock, Map<Slot, BlockParameter>> blockParameters, ArrayDeque<BlockParameter> cleanups) {
            if (visited.add(node)) {
                if (node instanceof OrderedNode) {
                    OrderedNode on = (OrderedNode)node;
                    this.buildSequence(on.getDependency(), visited, sequences, blockParameters, cleanups);
                }
                if (node instanceof BlockParameter) {
                    BlockParameter bp = (BlockParameter)node;
                    BasicBlock bpBlock = bp.getPinnedBlock();
                    blockParameters.computeIfAbsent(bpBlock, Context::newMap).put(bp.getSlot(), bp);
                    cleanups.addLast(bp);
                }
                int cnt = node.getValueDependencyCount();
                for (int i = 0; i < cnt; ++i) {
                    this.buildSequence(node.getValueDependency(i), visited, sequences, blockParameters, cleanups);
                }
                if (node instanceof Terminator) {
                    Terminator t = (Terminator)node;
                    cnt = t.getSuccessorCount();
                    for (int i = 0; i < cnt; ++i) {
                        this.buildSequence(t.getSuccessor(i).getTerminator(), visited, sequences, blockParameters, cleanups);
                    }
                } else if (!(node instanceof Unschedulable)) {
                    BasicBlock targetBlock = node.getScheduledBlock();
                    if (targetBlock == null) {
                        throw new IllegalStateException();
                    }
                    List<Node> list = sequences.get(targetBlock);
                    if (list == null) {
                        throw new IllegalStateException();
                    }
                    node.setScheduleIndex(list.size());
                    list.add(node);
                }
            }
        }

        private void upAndMark(int blockIdx, Value value) {
            BlockParameter bp;
            BlockInfo bi = this.allBlocks[blockIdx - 1];
            BasicBlock b = bi.block;
            if (value.getScheduledBlock() == b && !(value instanceof BlockParameter)) {
                return;
            }
            if (bi.liveIn.contains(value)) {
                return;
            }
            bi.liveIn.add(value);
            if (value instanceof BlockParameter && (bp = (BlockParameter)value).getPinnedBlock() == b) {
                return;
            }
            for (BasicBlock incoming : b.getIncoming()) {
                int pi = incoming.getIndex();
                BlockInfo p = this.allBlocks[pi - 1];
                p.liveOut.add(value);
                this.upAndMark(pi, value);
            }
        }

        private void computeLiveSetsByUse() {
            HashSet<Value> used = new HashSet<Value>();
            for (BlockInfo bi : this.allBlocks) {
                BasicBlock b = bi.block;
                Terminator t = b.getTerminator();
                int cnt = t.getSuccessorCount();
                for (int i = 0; i < cnt; ++i) {
                    BasicBlock successor = t.getSuccessor(i);
                    for (Slot slot : successor.getUsedParameterSlots()) {
                        Value out;
                        if (t.isImplicitOutboundArgument(slot, successor) || (out = t.getOutboundArgument(slot)) instanceof Literal || !bi.liveOut.add(out)) continue;
                        this.upAndMark(b.getIndex(), out);
                    }
                }
                for (Node node : b.getInstructions()) {
                    cnt = node.getValueDependencyCount();
                    for (int i = 0; i < cnt; ++i) {
                        Value dep = node.getValueDependency(i);
                        if (dep instanceof Literal || dep instanceof BlockParameter || !used.add(dep)) continue;
                        this.upAndMark(b.getIndex(), dep);
                    }
                }
                used.clear();
            }
        }

        private static <K, V> Map<K, V> newMap(Object ignored) {
            return new HashMap();
        }

        private static <E> Set<E> newSet(Object ignored) {
            return new HashSet();
        }
    }
}

