/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.schedule;

import io.smallrye.common.constraint.Assert;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.Value;

final class BlockInfo {
    final BasicBlock block;
    final int index;
    int dominator;
    int domDepth = -1;
    final BitSet pred = new BitSet();
    final BitSet succ = new BitSet();
    final BitSet bucket = new BitSet();
    int parent;
    int ancestor;
    int child;
    int vertex;
    int label;
    int semi;
    int size;
    final HashSet<Value> liveIn = new HashSet();
    final HashSet<Value> liveOut = new HashSet();

    BlockInfo(BasicBlock block, int index) {
        this.block = (BasicBlock)Assert.checkNotNullParam((String)"block", (Object)block);
        this.index = index;
    }

    void computeIndices(Map<BasicBlock, BlockInfo> blockInfos, int[] holder) {
        blockInfos.put(this.block, this);
        Terminator terminator = this.block.getTerminator();
        int cnt = terminator.getSuccessorCount();
        for (int i = 0; i < cnt; ++i) {
            BasicBlock block = terminator.getSuccessor(i);
            this.processBlock(blockInfos, holder, block);
            this.succ.set(blockInfos.get((Object)block).index - 1);
        }
    }

    private void processBlock(Map<BasicBlock, BlockInfo> blockInfos, int[] holder, BasicBlock block) {
        if (!blockInfos.containsKey(block)) {
            int n = holder[0];
            holder[0] = n + 1;
            new BlockInfo(block, n).computeIndices(blockInfos, holder);
        }
    }

    int findDomDepths(BlockInfo[] infos) {
        int domDepth = this.domDepth;
        if (domDepth == -1) {
            this.domDepth = this.dominator == 0 ? 0 : infos[this.dominator - 1].findDomDepths(infos) + 1;
            domDepth = this.domDepth;
        }
        return domDepth;
    }

    boolean dominates(BlockInfo[] allBlocks, BlockInfo other) {
        if (this == other || this.index == 1) {
            return true;
        }
        if (other.index == 1) {
            return false;
        }
        return this.dominates(allBlocks, allBlocks[other.dominator - 1]);
    }
}

