/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.graph.literal.WordLiteral;
import org.qbicc.type.ReferenceType;

public final class StringLiteral
extends WordLiteral {
    private final ReferenceType type;
    private final String value;
    private final boolean latin1;

    StringLiteral(ReferenceType type, String value) {
        this.type = type;
        this.value = value;
        boolean latin1 = true;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) < '\u0100') continue;
            latin1 = false;
            break;
        }
        this.latin1 = latin1;
    }

    @Override
    public ReferenceType getType() {
        return this.type;
    }

    public boolean isLatin1() {
        return this.latin1;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof StringLiteral && this.equals((StringLiteral)other);
    }

    public boolean equals(StringLiteral other) {
        return this == other || other != null && this.type.equals(other.type) && this.value.equals(other.value);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return b.append('\"').append(this.value).append('\"');
    }

    @Override
    public boolean isDefEq(Value other) {
        return this.equals(other);
    }

    @Override
    public boolean isDefNe(Value other) {
        return other instanceof StringLiteral && !this.equals((StringLiteral)other);
    }
}

