/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import java.util.Objects;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.type.PointerType;

public final class OffsetFromLiteral
extends Literal {
    final Literal basePointer;
    final Literal offset;

    OffsetFromLiteral(Literal basePointer, Literal offset) {
        this.basePointer = basePointer;
        this.offset = offset;
    }

    @Override
    public int getValueDependencyCount() {
        return 2;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return switch (index) {
            case 0 -> this.basePointer;
            case 1 -> this.offset;
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof OffsetFromLiteral && this.equals((OffsetFromLiteral)other);
    }

    public boolean equals(OffsetFromLiteral other) {
        return other == this || other != null && this.basePointer.equals(other.basePointer) && this.offset.equals(other.offset);
    }

    @Override
    public int hashCode() {
        return Objects.hash(OffsetFromLiteral.class, this.basePointer, this.offset);
    }

    @Override
    public PointerType getType() {
        return this.basePointer.getType(PointerType.class);
    }

    public Literal getBasePointer() {
        return this.basePointer;
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    public Literal getOffset() {
        return this.offset;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.offset.toString(this.basePointer.toString(b).append('+'));
    }
}

