/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import java.util.Objects;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.graph.literal.WordLiteral;
import org.qbicc.interpreter.VmObject;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.ReferenceType;

public final class ObjectLiteral
extends WordLiteral {
    private final ReferenceType type;
    private final VmObject value;
    private final int hashCode;

    ObjectLiteral(ReferenceType type, VmObject value) {
        this.type = type;
        this.value = value;
        this.hashCode = Objects.hash(type, value);
    }

    @Override
    public ReferenceType getType() {
        return this.type;
    }

    public PhysicalObjectType getObjectType() {
        return this.value.getObjectType();
    }

    public VmObject getValue() {
        return this.value;
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof ObjectLiteral && this.equals((ObjectLiteral)other);
    }

    public boolean equals(ObjectLiteral other) {
        return this == other || other != null && this.type.equals(other.type) && this.value.equals(other.value);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return b.append("object").append('(').append(this.value).append(')');
    }
}

