/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.graph.literal.WordLiteral;
import org.qbicc.type.IntegerType;
import org.qbicc.type.NullableType;
import org.qbicc.type.WordType;

public final class NullLiteral
extends WordLiteral {
    private final NullableType type;

    NullLiteral(NullableType type) {
        this.type = type;
    }

    @Override
    public NullableType getType() {
        return this.type;
    }

    @Override
    public boolean isZero() {
        return true;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof NullLiteral && this.equals((NullLiteral)other);
    }

    public boolean equals(NullLiteral other) {
        return other == this || other != null && this.type.equals(other.type);
    }

    @Override
    Literal bitCast(LiteralFactory lf, WordType toType) {
        if (toType instanceof IntegerType) {
            return lf.literalOf((IntegerType)toType, 0L);
        }
        if (toType instanceof NullableType) {
            return lf.nullLiteralOfType((NullableType)toType);
        }
        return super.bitCast(lf, toType);
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public boolean isDefNe(Value other) {
        return !other.isNullable();
    }

    @Override
    public boolean isDefEq(Value other) {
        return other instanceof NullLiteral;
    }

    @Override
    public int hashCode() {
        return NullLiteral.class.hashCode();
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return b.append("null");
    }

    @Override
    public String toString() {
        return "null";
    }
}

