/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import java.util.Objects;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.type.CompoundType;
import org.qbicc.type.PointerType;
import org.qbicc.type.WordType;

public final class MemberOfLiteral
extends Literal {
    final Literal structurePointer;
    final CompoundType.Member member;

    MemberOfLiteral(Literal structurePointer, CompoundType.Member member) {
        this.structurePointer = structurePointer;
        this.member = member;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        switch (index) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(index);
            }
        }
        return this.structurePointer;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof MemberOfLiteral && this.equals((MemberOfLiteral)other);
    }

    public boolean equals(MemberOfLiteral other) {
        return other == this || other != null && this.structurePointer.equals(other.structurePointer) && this.member.equals(other.member);
    }

    @Override
    public int hashCode() {
        return Objects.hash(MemberOfLiteral.class, this.structurePointer, this.member);
    }

    @Override
    Literal bitCast(LiteralFactory lf, WordType toType) {
        if (toType.equals(this.structurePointer.getType()) && this.member.getOffset() == 0) {
            return this.structurePointer;
        }
        return super.bitCast(lf, toType);
    }

    @Override
    public PointerType getType() {
        return this.member.getType().getPointer();
    }

    public Literal getStructurePointer() {
        return this.structurePointer;
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    public CompoundType.Member getMember() {
        return this.member;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.member.toString(this.structurePointer.toString(b).append('+'));
    }
}

