/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import io.smallrye.common.constraint.Assert;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.literal.ArrayLiteral;
import org.qbicc.graph.literal.AsmLiteral;
import org.qbicc.graph.literal.BlockLiteral;
import org.qbicc.graph.literal.BooleanLiteral;
import org.qbicc.graph.literal.ByteArrayLiteral;
import org.qbicc.graph.literal.CompoundLiteral;
import org.qbicc.graph.literal.ConstantLiteral;
import org.qbicc.graph.literal.ConstructorLiteral;
import org.qbicc.graph.literal.ElementOfLiteral;
import org.qbicc.graph.literal.ExecutableLiteral;
import org.qbicc.graph.literal.FloatLiteral;
import org.qbicc.graph.literal.FunctionLiteral;
import org.qbicc.graph.literal.GlobalVariableLiteral;
import org.qbicc.graph.literal.InitializerLiteral;
import org.qbicc.graph.literal.InstanceMethodLiteral;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.InvokableLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.MemberOfLiteral;
import org.qbicc.graph.literal.MethodHandleLiteral;
import org.qbicc.graph.literal.MethodLiteral;
import org.qbicc.graph.literal.NullLiteral;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.graph.literal.OffsetFromLiteral;
import org.qbicc.graph.literal.ProgramObjectLiteral;
import org.qbicc.graph.literal.ShortArrayLiteral;
import org.qbicc.graph.literal.StaticFieldLiteral;
import org.qbicc.graph.literal.StaticMethodLiteral;
import org.qbicc.graph.literal.StringLiteral;
import org.qbicc.graph.literal.TypeLiteral;
import org.qbicc.graph.literal.UndefinedLiteral;
import org.qbicc.graph.literal.VariableLiteral;
import org.qbicc.graph.literal.ZeroInitializerLiteral;
import org.qbicc.interpreter.VmObject;
import org.qbicc.object.ProgramObject;
import org.qbicc.pointer.ConstructorPointer;
import org.qbicc.pointer.ElementPointer;
import org.qbicc.pointer.FunctionPointer;
import org.qbicc.pointer.GlobalPointer;
import org.qbicc.pointer.InitializerPointer;
import org.qbicc.pointer.InstanceMethodPointer;
import org.qbicc.pointer.IntegerAsPointer;
import org.qbicc.pointer.MemberPointer;
import org.qbicc.pointer.OffsetPointer;
import org.qbicc.pointer.Pointer;
import org.qbicc.pointer.ProgramObjectPointer;
import org.qbicc.pointer.StaticFieldPointer;
import org.qbicc.pointer.StaticMethodPointer;
import org.qbicc.type.ArrayType;
import org.qbicc.type.BooleanType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.FloatType;
import org.qbicc.type.FunctionType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.NullableType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FunctionElement;
import org.qbicc.type.definition.element.GlobalVariableElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.InvokableElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.definition.element.StaticMethodElement;
import org.qbicc.type.definition.element.VariableElement;
import org.qbicc.type.methodhandle.MethodHandleConstant;

public interface LiteralFactory {
    public BlockLiteral literalOf(BlockLabel var1);

    public BooleanLiteral literalOf(boolean var1);

    public FloatLiteral literalOf(float var1);

    public FloatLiteral literalOf(double var1);

    public FloatLiteral literalOf(FloatType var1, double var2);

    public IntegerLiteral literalOf(long var1);

    public IntegerLiteral literalOf(int var1);

    public IntegerLiteral literalOf(short var1);

    public IntegerLiteral literalOf(byte var1);

    public IntegerLiteral literalOf(char var1);

    public IntegerLiteral literalOf(IntegerType var1, long var2);

    public StringLiteral literalOf(String var1, ReferenceType var2);

    public ObjectLiteral literalOf(VmObject var1);

    public MethodHandleLiteral literalOfMethodHandle(MethodHandleConstant var1, ReferenceType var2);

    public ProgramObjectLiteral literalOf(ProgramObject var1);

    public UndefinedLiteral undefinedLiteralOfType(ValueType var1);

    public ConstantLiteral constantLiteralOfType(ValueType var1);

    public TypeLiteral literalOfType(ValueType var1);

    public NullLiteral nullLiteralOfType(NullableType var1);

    public Literal zeroInitializerLiteralOfType(ValueType var1);

    public Literal literalOf(ArrayType var1, List<Literal> var2);

    public Literal literalOf(ArrayType var1, byte[] var2);

    public Literal literalOf(ArrayType var1, short[] var2);

    public Literal literalOf(CompoundType var1, Map<CompoundType.Member, Literal> var2);

    public Literal bitcastLiteral(Literal var1, WordType var2);

    public Literal valueConvertLiteral(Literal var1, WordType var2);

    public ElementOfLiteral elementOfLiteral(Literal var1, Literal var2);

    public MemberOfLiteral memberOfLiteral(Literal var1, CompoundType.Member var2);

    public OffsetFromLiteral offsetFromLiteral(Literal var1, Literal var2);

    default public Literal literalOf(Pointer value) {
        return value.accept(new Pointer.Visitor<LiteralFactory, Literal>(){

            @Override
            public Literal visitAny(LiteralFactory literalFactory, Pointer pointer) {
                throw new IllegalArgumentException("Invalid pointer");
            }

            @Override
            public Literal visit(LiteralFactory literalFactory, ConstructorPointer pointer) {
                return literalFactory.literalOf(pointer.getExecutableElement());
            }

            @Override
            public Literal visit(LiteralFactory literalFactory, FunctionPointer pointer) {
                return literalFactory.literalOf(pointer.getExecutableElement());
            }

            @Override
            public Literal visit(LiteralFactory literalFactory, GlobalPointer pointer) {
                return literalFactory.literalOf(pointer.getGlobalVariable());
            }

            @Override
            public Literal visit(LiteralFactory literalFactory, InitializerPointer pointer) {
                return literalFactory.literalOf(pointer.getExecutableElement());
            }

            @Override
            public Literal visit(LiteralFactory literalFactory, InstanceMethodPointer pointer) {
                return literalFactory.literalOf(pointer.getExecutableElement());
            }

            @Override
            public Literal visit(LiteralFactory literalFactory, IntegerAsPointer pointer) {
                return literalFactory.bitcastLiteral(literalFactory.literalOf(pointer.getType().getSameSizedUnsignedInteger(), pointer.getValue()), pointer.getType());
            }

            @Override
            public Literal visit(LiteralFactory literalFactory, ProgramObjectPointer pointer) {
                return literalFactory.literalOf(pointer.getProgramObject());
            }

            @Override
            public Literal visit(LiteralFactory literalFactory, StaticFieldPointer pointer) {
                return literalFactory.literalOf(pointer.getStaticField());
            }

            @Override
            public Literal visit(LiteralFactory literalFactory, StaticMethodPointer pointer) {
                return literalFactory.literalOf(pointer.getExecutableElement());
            }

            @Override
            public Literal visit(LiteralFactory literalFactory, ElementPointer pointer) {
                return literalFactory.elementOfLiteral(literalFactory.literalOf(pointer.getArrayPointer()), literalFactory.literalOf(pointer.getIndex()));
            }

            @Override
            public Literal visit(LiteralFactory literalFactory, MemberPointer pointer) {
                return literalFactory.memberOfLiteral(literalFactory.literalOf(pointer.getStructurePointer()), pointer.getMember());
            }

            @Override
            public Literal visit(LiteralFactory literalFactory, OffsetPointer pointer) {
                return literalFactory.offsetFromLiteral(literalFactory.literalOf(pointer.getBasePointer()), literalFactory.literalOf(pointer.getOffset()));
            }
        }, this);
    }

    public GlobalVariableLiteral literalOf(GlobalVariableElement var1);

    public StaticFieldLiteral literalOf(StaticFieldElement var1);

    public AsmLiteral literalOfAsm(String var1, String var2, FunctionType var3, AsmLiteral.Flag ... var4);

    default public ExecutableLiteral literalOf(ExecutableElement element) {
        if (element instanceof InitializerElement) {
            InitializerElement ie = (InitializerElement)element;
            return this.literalOf(ie);
        }
        if (element instanceof InvokableElement) {
            InvokableElement ie = (InvokableElement)element;
            return this.literalOf(ie);
        }
        throw new IllegalStateException();
    }

    default public InvokableLiteral literalOf(InvokableElement element) {
        if (element instanceof ConstructorElement) {
            ConstructorElement ce = (ConstructorElement)element;
            return this.literalOf(ce);
        }
        if (element instanceof FunctionElement) {
            FunctionElement fe = (FunctionElement)element;
            return this.literalOf(fe);
        }
        if (element instanceof MethodElement) {
            MethodElement me = (MethodElement)element;
            return this.literalOf(me);
        }
        throw new IllegalStateException();
    }

    default public MethodLiteral literalOf(MethodElement element) {
        if (element instanceof InstanceMethodElement) {
            InstanceMethodElement ime = (InstanceMethodElement)element;
            return this.literalOf(ime);
        }
        if (element instanceof StaticMethodElement) {
            StaticMethodElement sme = (StaticMethodElement)element;
            return this.literalOf(sme);
        }
        throw new IllegalStateException();
    }

    public StaticMethodLiteral literalOf(StaticMethodElement var1);

    public ConstructorLiteral literalOf(ConstructorElement var1);

    public InstanceMethodLiteral literalOf(InstanceMethodElement var1);

    public InitializerLiteral literalOf(InitializerElement var1);

    public FunctionLiteral literalOf(FunctionElement var1);

    public static LiteralFactory create(final TypeSystem typeSystem) {
        return new LiteralFactory(){
            private final BooleanLiteral TRUE;
            private final BooleanLiteral FALSE;
            private final ConcurrentMap<String, StringLiteral> stringLiterals;
            private final ConcurrentMap<IntegerLiteral, IntegerLiteral> integerLiterals;
            private final ConcurrentMap<FloatLiteral, FloatLiteral> floatLiterals;
            private final ConcurrentMap<ProgramObject, ProgramObjectLiteral> programObjects;
            private final ConcurrentMap<ValueType, TypeLiteral> typeLiterals;
            private final ConcurrentMap<ValueType, ZeroInitializerLiteral> zeroLiterals;
            private final ConcurrentMap<NullableType, NullLiteral> nullLiterals;
            private final ConcurrentMap<ValueType, UndefinedLiteral> undefLiterals;
            private final ConcurrentMap<ValueType, ConstantLiteral> constantLiterals;
            private final ConcurrentMap<VariableElement, VariableLiteral> varLiterals;
            private final ConcurrentMap<ExecutableElement, ExecutableLiteral> exeLiterals;
            private final ConcurrentMap<Literal, ConcurrentMap<Literal, ElementOfLiteral>> elementLiterals;
            private final ConcurrentMap<Literal, ConcurrentMap<CompoundType.Member, MemberOfLiteral>> memberLiterals;
            private final ConcurrentMap<Literal, ConcurrentMap<Literal, OffsetFromLiteral>> offsetLiterals;
            {
                this.TRUE = new BooleanLiteral(typeSystem.getBooleanType(), true);
                this.FALSE = new BooleanLiteral(typeSystem.getBooleanType(), false);
                this.stringLiterals = new ConcurrentHashMap<String, StringLiteral>();
                this.integerLiterals = new ConcurrentHashMap<IntegerLiteral, IntegerLiteral>();
                this.floatLiterals = new ConcurrentHashMap<FloatLiteral, FloatLiteral>();
                this.programObjects = new ConcurrentHashMap<ProgramObject, ProgramObjectLiteral>();
                this.typeLiterals = new ConcurrentHashMap<ValueType, TypeLiteral>();
                this.zeroLiterals = new ConcurrentHashMap<ValueType, ZeroInitializerLiteral>();
                this.nullLiterals = new ConcurrentHashMap<NullableType, NullLiteral>();
                this.undefLiterals = new ConcurrentHashMap<ValueType, UndefinedLiteral>();
                this.constantLiterals = new ConcurrentHashMap<ValueType, ConstantLiteral>();
                this.varLiterals = new ConcurrentHashMap<VariableElement, VariableLiteral>();
                this.exeLiterals = new ConcurrentHashMap<ExecutableElement, ExecutableLiteral>();
                this.elementLiterals = new ConcurrentHashMap<Literal, ConcurrentMap<Literal, ElementOfLiteral>>();
                this.memberLiterals = new ConcurrentHashMap<Literal, ConcurrentMap<CompoundType.Member, MemberOfLiteral>>();
                this.offsetLiterals = new ConcurrentHashMap<Literal, ConcurrentMap<Literal, OffsetFromLiteral>>();
            }

            @Override
            public BlockLiteral literalOf(BlockLabel blockLabel) {
                return new BlockLiteral(typeSystem.getBlockType(), blockLabel);
            }

            @Override
            public BooleanLiteral literalOf(boolean value) {
                return value ? this.TRUE : this.FALSE;
            }

            @Override
            public FloatLiteral literalOf(float value) {
                return this.literalOf(typeSystem.getFloat32Type(), value);
            }

            @Override
            public FloatLiteral literalOf(double value) {
                return this.literalOf(typeSystem.getFloat64Type(), value);
            }

            @Override
            public FloatLiteral literalOf(FloatType type, double value) {
                FloatLiteral v = new FloatLiteral(type, value);
                return this.floatLiterals.computeIfAbsent(v, Function.identity());
            }

            @Override
            public IntegerLiteral literalOf(long value) {
                return this.literalOf(typeSystem.getSignedInteger64Type(), value);
            }

            @Override
            public IntegerLiteral literalOf(int value) {
                return this.literalOf(typeSystem.getSignedInteger32Type(), value);
            }

            @Override
            public IntegerLiteral literalOf(short value) {
                return this.literalOf(typeSystem.getSignedInteger16Type(), value);
            }

            @Override
            public IntegerLiteral literalOf(byte value) {
                return this.literalOf(typeSystem.getSignedInteger8Type(), value);
            }

            @Override
            public IntegerLiteral literalOf(char value) {
                return this.literalOf(typeSystem.getUnsignedInteger16Type(), value);
            }

            @Override
            public IntegerLiteral literalOf(IntegerType type, long value) {
                IntegerLiteral v = new IntegerLiteral(type, value);
                return this.integerLiterals.computeIfAbsent(v, Function.identity());
            }

            @Override
            public StringLiteral literalOf(String value, ReferenceType stringRefType) {
                return this.stringLiterals.computeIfAbsent(value, v -> new StringLiteral(stringRefType, (String)v));
            }

            @Override
            public UndefinedLiteral undefinedLiteralOfType(ValueType type) {
                return this.undefLiterals.computeIfAbsent(type, UndefinedLiteral::new);
            }

            @Override
            public ConstantLiteral constantLiteralOfType(ValueType type) {
                return this.constantLiterals.computeIfAbsent(type, ConstantLiteral::new);
            }

            @Override
            public ObjectLiteral literalOf(VmObject value) {
                Assert.checkNotNullParam((String)"value", (Object)value);
                return new ObjectLiteral(value.getObjectType().getReference(), value);
            }

            @Override
            public MethodHandleLiteral literalOfMethodHandle(MethodHandleConstant methodHandleConstant, ReferenceType type) {
                return new MethodHandleLiteral(methodHandleConstant, type);
            }

            @Override
            public ProgramObjectLiteral literalOf(ProgramObject programObject) {
                return this.programObjects.computeIfAbsent(programObject, ProgramObjectLiteral::new);
            }

            @Override
            public TypeLiteral literalOfType(ValueType type) {
                Assert.checkNotNullParam((String)"type", (Object)type);
                return this.typeLiterals.computeIfAbsent(type, TypeLiteral::new);
            }

            @Override
            public NullLiteral nullLiteralOfType(NullableType type) {
                Assert.checkNotNullParam((String)"type", (Object)type);
                return this.nullLiterals.computeIfAbsent(type, NullLiteral::new);
            }

            @Override
            public Literal zeroInitializerLiteralOfType(ValueType type) {
                Assert.checkNotNullParam((String)"type", (Object)type);
                if (type instanceof IntegerType) {
                    return this.literalOf((IntegerType)type, 0L);
                }
                if (type instanceof FloatType) {
                    return this.literalOf((FloatType)type, 0.0);
                }
                if (type instanceof BooleanType) {
                    return this.literalOf(false);
                }
                if (type instanceof NullableType) {
                    return this.nullLiteralOfType((NullableType)type);
                }
                return this.zeroLiterals.computeIfAbsent(type, ZeroInitializerLiteral::new);
            }

            @Override
            public Literal literalOf(ArrayType type, List<Literal> values) {
                Assert.checkNotNullParam((String)"type", (Object)type);
                Assert.checkNotNullParam((String)"values", values);
                if (type.getElementCount() != (long)values.size()) {
                    throw new IllegalArgumentException("Cannot construct array literal with different element count than the size of the list of values");
                }
                for (Literal value : values) {
                    if (!value.isNonZero()) continue;
                    return new ArrayLiteral(type, values);
                }
                return this.zeroInitializerLiteralOfType(type);
            }

            @Override
            public Literal literalOf(ArrayType type, byte[] values) {
                Assert.checkNotNullParam((String)"type", (Object)type);
                Assert.checkNotNullParam((String)"values", (Object)values);
                if (type.getElementCount() != (long)values.length) {
                    throw new IllegalArgumentException("Cannot construct array literal with different element count than the size of the list of values");
                }
                for (byte value : values) {
                    if (value == 0) continue;
                    return new ByteArrayLiteral(type, values);
                }
                return this.zeroInitializerLiteralOfType(type);
            }

            @Override
            public Literal literalOf(ArrayType type, short[] values) {
                Assert.checkNotNullParam((String)"type", (Object)type);
                Assert.checkNotNullParam((String)"values", (Object)values);
                if (type.getElementCount() != (long)values.length) {
                    throw new IllegalArgumentException("Cannot construct array literal with different element count than the size of the list of values");
                }
                for (short value : values) {
                    if (value == 0) continue;
                    return new ShortArrayLiteral(type, values);
                }
                return this.zeroInitializerLiteralOfType(type);
            }

            @Override
            public Literal literalOf(CompoundType type, Map<CompoundType.Member, Literal> values) {
                Assert.checkNotNullParam((String)"type", (Object)type);
                Assert.checkNotNullParam((String)"values", values);
                for (Literal value : values.values()) {
                    if (!value.isNonZero()) continue;
                    return new CompoundLiteral(type, values);
                }
                return this.zeroInitializerLiteralOfType(type);
            }

            @Override
            public Literal bitcastLiteral(Literal value, WordType toType) {
                Assert.checkNotNullParam((String)"value", (Object)value);
                Assert.checkNotNullParam((String)"toType", (Object)toType);
                return value.bitCast(this, toType);
            }

            @Override
            public Literal valueConvertLiteral(Literal value, WordType toType) {
                Assert.checkNotNullParam((String)"value", (Object)value);
                Assert.checkNotNullParam((String)"toType", (Object)toType);
                return value.convert(this, toType);
            }

            @Override
            public ElementOfLiteral elementOfLiteral(Literal arrayPointer, Literal index) {
                ElementOfLiteral appearing;
                Assert.checkNotNullParam((String)"arrayPointer", (Object)arrayPointer);
                Assert.checkNotNullParam((String)"index", (Object)index);
                ValueType pointeeType = arrayPointer.getPointeeType();
                if (!(pointeeType instanceof ArrayType)) {
                    throw new IllegalArgumentException("Array pointer is of wrong type " + pointeeType);
                }
                ValueType indexType = index.getType();
                if (!(indexType instanceof IntegerType)) {
                    throw new IllegalArgumentException("Index is of wrong type " + indexType);
                }
                ConcurrentMap subMap = this.elementLiterals.computeIfAbsent(arrayPointer, LiteralFactory::newMap);
                ElementOfLiteral lit = (ElementOfLiteral)subMap.get(index);
                if (lit == null && (appearing = subMap.putIfAbsent(index, lit = new ElementOfLiteral(arrayPointer, index))) != null) {
                    lit = appearing;
                }
                return lit;
            }

            @Override
            public MemberOfLiteral memberOfLiteral(Literal structurePointer, CompoundType.Member member) {
                MemberOfLiteral appearing;
                Assert.checkNotNullParam((String)"structurePointer", (Object)structurePointer);
                Assert.checkNotNullParam((String)"member", (Object)member);
                ValueType structureType = structurePointer.getPointeeType();
                if (!(structureType instanceof CompoundType)) {
                    throw new IllegalArgumentException("Structure pointer is of wrong type " + structureType);
                }
                ConcurrentMap subMap = this.memberLiterals.computeIfAbsent(structurePointer, LiteralFactory::newMap);
                MemberOfLiteral lit = (MemberOfLiteral)subMap.get(member);
                if (lit == null && (appearing = subMap.putIfAbsent(member, lit = new MemberOfLiteral(structurePointer, member))) != null) {
                    lit = appearing;
                }
                return lit;
            }

            @Override
            public OffsetFromLiteral offsetFromLiteral(Literal basePointer, Literal offset) {
                OffsetFromLiteral appearing;
                Assert.checkNotNullParam((String)"basePointer", (Object)basePointer);
                Assert.checkNotNullParam((String)"offset", (Object)offset);
                ValueType basePointerType = basePointer.getType();
                if (!(basePointerType instanceof PointerType)) {
                    throw new IllegalArgumentException("Base pointer is of wrong type " + basePointerType);
                }
                ValueType offsetType = offset.getType();
                if (!(offsetType instanceof IntegerType)) {
                    throw new IllegalArgumentException("Offset is of wrong type " + offsetType);
                }
                ConcurrentMap subMap = this.offsetLiterals.computeIfAbsent(basePointer, LiteralFactory::newMap);
                OffsetFromLiteral lit = (OffsetFromLiteral)subMap.get(offset);
                if (lit == null && (appearing = subMap.putIfAbsent(offset, lit = new OffsetFromLiteral(basePointer, offset))) != null) {
                    lit = appearing;
                }
                return lit;
            }

            @Override
            public GlobalVariableLiteral literalOf(GlobalVariableElement variableElement) {
                Assert.checkNotNullParam((String)"variableElement", (Object)variableElement);
                return (GlobalVariableLiteral)this.varLiterals.computeIfAbsent(variableElement, GlobalVariableLiteral::new);
            }

            @Override
            public StaticFieldLiteral literalOf(StaticFieldElement variableElement) {
                Assert.checkNotNullParam((String)"variableElement", (Object)variableElement);
                return (StaticFieldLiteral)this.varLiterals.computeIfAbsent(variableElement, StaticFieldLiteral::new);
            }

            @Override
            public AsmLiteral literalOfAsm(String instructions, String constraints, FunctionType type, AsmLiteral.Flag ... flags) {
                Assert.checkNotNullParam((String)"instructions", (Object)instructions);
                Assert.checkNotNullParam((String)"constraints", (Object)constraints);
                Assert.checkNotNullParam((String)"type", (Object)type);
                Set<AsmLiteral.Flag> flagSet = flags == null ? Set.of() : Set.of(flags);
                return new AsmLiteral(instructions, constraints, flagSet, type);
            }

            @Override
            public StaticMethodLiteral literalOf(StaticMethodElement element) {
                Assert.checkNotNullParam((String)"element", (Object)element);
                return (StaticMethodLiteral)this.exeLiterals.computeIfAbsent(element, StaticMethodLiteral::new);
            }

            @Override
            public ConstructorLiteral literalOf(ConstructorElement element) {
                Assert.checkNotNullParam((String)"element", (Object)element);
                return (ConstructorLiteral)this.exeLiterals.computeIfAbsent(element, ConstructorLiteral::new);
            }

            @Override
            public InstanceMethodLiteral literalOf(InstanceMethodElement element) {
                Assert.checkNotNullParam((String)"element", (Object)element);
                return (InstanceMethodLiteral)this.exeLiterals.computeIfAbsent(element, InstanceMethodLiteral::new);
            }

            @Override
            public InitializerLiteral literalOf(InitializerElement element) {
                Assert.checkNotNullParam((String)"element", (Object)element);
                return (InitializerLiteral)this.exeLiterals.computeIfAbsent(element, InitializerLiteral::new);
            }

            @Override
            public FunctionLiteral literalOf(FunctionElement element) {
                Assert.checkNotNullParam((String)"element", (Object)element);
                return (FunctionLiteral)this.exeLiterals.computeIfAbsent(element, FunctionLiteral::new);
            }
        };
    }

    private static <K, V> ConcurrentMap<K, V> newMap(Object ignored) {
        return new ConcurrentHashMap();
    }
}

