/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.graph.literal.WordLiteral;
import org.qbicc.type.FloatType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.WordType;

public final class FloatLiteral
extends WordLiteral {
    private final FloatType type;
    private final double value;
    private final int hashCode;

    FloatLiteral(FloatType type, double value) {
        this.type = type;
        this.value = value;
        long bits = Double.doubleToRawLongBits(value);
        this.hashCode = (int)(bits ^ bits >>> 32) * 19 + type.hashCode();
    }

    @Override
    public FloatType getType() {
        return this.type;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    @Override
    public boolean isZero() {
        return Double.doubleToRawLongBits(this.value) == 0L;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof FloatLiteral && this.equals((FloatLiteral)other);
    }

    public boolean equals(FloatLiteral other) {
        return this == other || other != null && Double.doubleToRawLongBits(this.value) == Double.doubleToRawLongBits(other.value) && this.type.equals(other.type);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    Literal bitCast(LiteralFactory lf, WordType toType) {
        int minBits = this.type.getMinBits();
        if (toType.getMinBits() != minBits) {
            throw new IllegalArgumentException("Invalid literal bitcast between differently-sized types");
        }
        if (toType instanceof IntegerType) {
            return lf.literalOf((IntegerType)toType, minBits == 32 ? (long)Float.floatToRawIntBits(this.floatValue()) : Double.doubleToRawLongBits(this.value));
        }
        return super.bitCast(lf, toType);
    }

    @Override
    Literal convert(LiteralFactory lf, WordType toType) {
        if (toType instanceof IntegerType) {
            int minBits = toType.getMinBits();
            if (toType instanceof SignedIntegerType) {
                if (minBits == 8) {
                    return lf.literalOf((SignedIntegerType)toType, Math.min(127, Math.max(-128, (int)this.value)));
                }
                if (minBits == 16) {
                    return lf.literalOf((SignedIntegerType)toType, Math.min(Short.MAX_VALUE, Math.max(Short.MIN_VALUE, (int)this.value)));
                }
                if (minBits == 32) {
                    return lf.literalOf((SignedIntegerType)toType, (int)this.value);
                }
                if (minBits == 64) {
                    return lf.literalOf((SignedIntegerType)toType, (long)this.value);
                }
            } else if (toType instanceof UnsignedIntegerType) {
                if (minBits == 8) {
                    return lf.literalOf((UnsignedIntegerType)toType, Math.min(255, Math.max(0, (int)this.value)));
                }
                if (minBits == 16) {
                    return lf.literalOf((UnsignedIntegerType)toType, Math.min(65535, Math.max(0, (int)this.value)));
                }
                if (minBits == 32) {
                    return lf.literalOf((UnsignedIntegerType)toType, Math.min(0xFFFFFFFFL, Math.max(0L, (long)this.value)));
                }
                if (minBits == 64) {
                    // empty if block
                }
            }
        }
        return super.convert(lf, toType);
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.type.toString(b).append(' ').append(this.value).append(' ').append('(').append(Double.toHexString(this.value)).append(')');
    }

    @Override
    public boolean isDefEq(Value other) {
        return other instanceof FloatLiteral && this.value == ((FloatLiteral)other).value && this.type.equals(((FloatLiteral)other).type);
    }

    @Override
    public boolean isDefNe(Value other) {
        return other instanceof FloatLiteral && this.value != ((FloatLiteral)other).value && this.type.equals(((FloatLiteral)other).type);
    }

    @Override
    public boolean isDefLt(Value other) {
        return other instanceof FloatLiteral && this.value < ((FloatLiteral)other).value && this.type.equals(((FloatLiteral)other).type);
    }

    @Override
    public boolean isDefGt(Value other) {
        return other instanceof FloatLiteral && this.value > ((FloatLiteral)other).value && this.type.equals(((FloatLiteral)other).type);
    }

    @Override
    public boolean isDefLe(Value other) {
        return other instanceof FloatLiteral && this.value <= ((FloatLiteral)other).value && this.type.equals(((FloatLiteral)other).type);
    }

    @Override
    public boolean isDefGe(Value other) {
        return other instanceof FloatLiteral && this.value >= ((FloatLiteral)other).value && this.type.equals(((FloatLiteral)other).type);
    }

    @Override
    public boolean isDefNaN() {
        return Double.isNaN(this.value);
    }

    @Override
    public boolean isDefNotNaN() {
        return !Double.isNaN(this.value);
    }
}

