/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import org.qbicc.graph.literal.Literal;
import org.qbicc.type.InvokableType;
import org.qbicc.type.PointerType;
import org.qbicc.type.definition.element.ExecutableElement;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ExecutableLiteral
extends Literal {
    private final ExecutableElement element;

    ExecutableLiteral(ExecutableElement element) {
        this.element = element;
    }

    public ExecutableElement getExecutable() {
        return this.element;
    }

    @Override
    public final boolean equals(Literal other) {
        ExecutableLiteral el;
        return other instanceof ExecutableLiteral && this.equals(el = (ExecutableLiteral)other);
    }

    public boolean equals(ExecutableLiteral other) {
        return this == other || other != null && this.element.equals(other.element);
    }

    @Override
    public int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public PointerType getType() {
        return this.element.getType().getPointer();
    }

    @Override
    public InvokableType getPointeeType() {
        return this.element.getType();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return false;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean isPointeeConstant() {
        return true;
    }

    @Override
    public boolean isNoThrow() {
        return this.element.hasAllModifiersOf(0x4000000);
    }

    @Override
    public boolean isNoSafePoints() {
        return this.element.hasAllModifiersOf(131072);
    }

    @Override
    public boolean isNoReturn() {
        return this.element.hasAllModifiersOf(0x2000000);
    }

    @Override
    public boolean isNoSideEffect() {
        return this.element.hasAllModifiersOf(0x400000);
    }

    @Override
    public boolean isFold() {
        return this.element.hasAllModifiersOf(0x8000000);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.toReferenceString(b);
    }
}

