/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.type.CompoundType;

public final class CompoundLiteral
extends Literal {
    private final CompoundType type;
    private final Map<CompoundType.Member, Literal> values;
    private final List<Literal> valuesAsList;
    private final int hashCode;

    CompoundLiteral(CompoundType type, Map<CompoundType.Member, Literal> values) {
        this.type = type;
        this.values = values;
        this.hashCode = Objects.hash(type, values);
        this.valuesAsList = new ArrayList<Literal>(values.size());
        for (CompoundType.Member member : type.getMembers()) {
            Literal literal = values.get(member);
            if (literal == null) continue;
            this.valuesAsList.add(literal);
        }
    }

    @Override
    public int getValueDependencyCount() {
        return this.valuesAsList.size();
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return this.valuesAsList.get(index);
    }

    @Override
    public CompoundType getType() {
        return this.type;
    }

    public Map<CompoundType.Member, Literal> getValues() {
        return this.values;
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public Value extractMember(LiteralFactory lf, CompoundType.Member member) {
        return this.values.get(member);
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof CompoundLiteral && this.equals((CompoundLiteral)other);
    }

    public boolean equals(CompoundLiteral other) {
        return this == other || other != null && this.hashCode == other.hashCode && this.type.equals(other.type) && this.values.equals(other.values);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public StringBuilder toString(StringBuilder builder) {
        builder.append('{');
        Iterator<Map.Entry<CompoundType.Member, Literal>> iterator = this.values.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<CompoundType.Member, Literal> entry = iterator.next();
            builder.append(entry.getKey().getName());
            builder.append('=');
            builder.append(entry.getValue());
            while (iterator.hasNext()) {
                builder.append(',');
                entry = iterator.next();
                builder.append(entry.getKey().getName());
                builder.append('=');
                builder.append(entry.getValue());
            }
        }
        builder.append('}');
        return builder;
    }
}

