/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import java.util.Objects;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.type.BlockType;

public final class BlockLiteral
extends Literal {
    private final BlockType type;
    private final BlockLabel blockLabel;
    private final int hashCode;

    BlockLiteral(BlockType type, BlockLabel blockLabel) {
        this.type = type;
        this.blockLabel = blockLabel;
        this.hashCode = Objects.hash(BlockLiteral.class, blockLabel);
    }

    @Override
    public BlockType getType() {
        return this.type;
    }

    public BlockLabel getBlockLabel() {
        return this.blockLabel;
    }

    public BasicBlock getBlock() {
        return BlockLabel.getTargetOf(this.blockLabel);
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof BlockLiteral && this.equals((BlockLiteral)other);
    }

    public boolean equals(BlockLiteral other) {
        return this == other || other != null && this.blockLabel.equals(other.blockLabel) && this.type.equals(other.type);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return b.append("block").append('(').append(this.blockLabel).append(')');
    }
}

