/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.type.WordType;

public class BitCastLiteral
extends Literal {
    final Literal value;
    final WordType toType;

    BitCastLiteral(Literal value, WordType toType) {
        this.value = value;
        this.toType = toType;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        switch (index) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(index);
            }
        }
        return this.value;
    }

    @Override
    public WordType getType() {
        return this.toType;
    }

    public Literal getValue() {
        return this.value;
    }

    @Override
    public boolean isZero() {
        return this.value.isZero();
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof BitCastLiteral && this.equals((BitCastLiteral)other);
    }

    public boolean equals(BitCastLiteral other) {
        return other == this || other != null && this.toType.equals(other.toType) && this.value.equals(other.value);
    }

    @Override
    Literal bitCast(LiteralFactory lf, WordType toType) {
        return lf.bitcastLiteral(this.value, toType);
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode() * 19 + this.toType.hashCode();
    }

    @Override
    public boolean isNullable() {
        return this.value.isNullable();
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        b.append("bitcast").append('(');
        this.value.toString(b);
        b.append(" to ");
        this.toType.toString(b);
        b.append(')');
        return b;
    }
}

