/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractTerminator;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.Node;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.type.definition.element.ExecutableElement;

public final class Throw
extends AbstractTerminator
implements Terminator {
    private final Node dependency;
    private final Value thrownValue;
    private final BasicBlock terminatedBlock;

    Throw(Node callSite, ExecutableElement element, int line, int bci, BlockEntry blockEntry, Node dependency, Value thrownValue) {
        super(callSite, element, line, bci);
        this.terminatedBlock = new BasicBlock(blockEntry, this);
        this.dependency = dependency;
        this.thrownValue = thrownValue;
    }

    @Override
    public BasicBlock getTerminatedBlock() {
        return this.terminatedBlock;
    }

    public Value getThrownValue() {
        return this.thrownValue;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.thrownValue : (Value)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public boolean maySafePoint() {
        return false;
    }

    @Override
    public <T, R> R accept(TerminatorVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    int calcHashCode() {
        return Objects.hash(Throw.class, this.dependency, this.thrownValue);
    }

    @Override
    String getNodeName() {
        return "Throw";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Throw && this.equals((Throw)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.thrownValue.toReferenceString(b);
        b.append(')');
        return b;
    }

    public boolean equals(Throw other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.thrownValue.equals(other.thrownValue);
    }
}

