/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.List;
import java.util.Objects;
import org.qbicc.graph.AbstractTerminator;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.InvocationNode;
import org.qbicc.graph.Node;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Value;
import org.qbicc.type.InvokableType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class TailCall
extends AbstractTerminator
implements InvocationNode {
    private final Node dependency;
    private final BasicBlock terminatedBlock;
    private final Value target;
    private final Value receiver;
    private final List<Value> arguments;
    private final InvokableType calleeType;

    TailCall(Node callSite, ExecutableElement element, int line, int bci, BlockEntry blockEntry, Node dependency, Value target, Value receiver, List<Value> arguments) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.terminatedBlock = new BasicBlock(blockEntry, this);
        this.target = target;
        this.receiver = receiver;
        this.arguments = arguments;
        this.calleeType = (InvokableType)target.getPointeeType();
    }

    @Override
    int calcHashCode() {
        return Objects.hash(TailCall.class, this.dependency, this.target, this.receiver, this.arguments);
    }

    @Override
    String getNodeName() {
        return "TailCall";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof TailCall && this.equals((TailCall)other);
    }

    public boolean equals(TailCall other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.target.equals(other.target) && this.receiver.equals(other.receiver) && this.arguments.equals(other.arguments);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return InvocationNode.toRValueString(this, "tail call", b);
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public boolean maySafePoint() {
        return !this.target.isNoSafePoints();
    }

    @Override
    public InvokableType getCalleeType() {
        return this.calleeType;
    }

    @Override
    public List<Value> getArguments() {
        return this.arguments;
    }

    @Override
    public Value getTarget() {
        return this.target;
    }

    @Override
    public Value getReceiver() {
        return this.receiver;
    }

    @Override
    public BasicBlock getTerminatedBlock() {
        return this.terminatedBlock;
    }

    @Override
    public <T, R> R accept(TerminatorVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

