/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.qbicc.graph.AbstractTerminator;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.Node;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.type.definition.element.ExecutableElement;

public final class Switch
extends AbstractTerminator
implements Terminator {
    private final Node dependency;
    private final BlockLabel defaultTargetLabel;
    private final int[] values;
    private final BlockLabel[] targetLabels;
    private final Value switchValue;
    private final BasicBlock terminatedBlock;

    Switch(Node callSite, ExecutableElement element, int line, int bci, BlockEntry blockEntry, Node dependency, BlockLabel defaultTargetLabel, int[] values, BlockLabel[] targetLabels, Value switchValue, Map<Slot, Value> targetArguments) {
        super(callSite, element, line, bci, targetArguments);
        this.terminatedBlock = new BasicBlock(blockEntry, this);
        this.dependency = dependency;
        this.defaultTargetLabel = defaultTargetLabel;
        int max = Integer.MIN_VALUE;
        int valuesLength = values.length;
        for (int i = 0; i < valuesLength; ++i) {
            int value = values[i];
            if (value > max) {
                max = value;
                continue;
            }
            if (value > max || i == 0) continue;
            throw new IllegalArgumentException("Switch values must strictly increase");
        }
        this.values = values;
        this.targetLabels = targetLabels;
        this.switchValue = switchValue;
    }

    @Override
    public BasicBlock getTerminatedBlock() {
        return this.terminatedBlock;
    }

    public Value getSwitchValue() {
        return this.switchValue;
    }

    public BlockLabel getDefaultTargetLabel() {
        return this.defaultTargetLabel;
    }

    public BasicBlock getDefaultTarget() {
        return BlockLabel.getTargetOf(this.defaultTargetLabel);
    }

    public int getNumberOfValues() {
        return this.values.length;
    }

    public int getValueForIndex(int index) throws IndexOutOfBoundsException {
        return this.values[index];
    }

    public int getIndexForValue(int value) {
        int idx = Arrays.binarySearch(this.values, value);
        return idx < 0 ? -1 : idx;
    }

    public int[] getValues() {
        return this.values;
    }

    public BlockLabel getTargetLabelForIndex(int index) {
        return this.targetLabels[index];
    }

    public BlockLabel getTargetLabelForValue(int value) {
        int idx = Arrays.binarySearch(this.values, value);
        return idx < 0 ? null : this.targetLabels[idx];
    }

    public BasicBlock getTargetForIndex(int index) {
        return BlockLabel.getTargetOf(this.targetLabels[index]);
    }

    public BasicBlock getTargetForValue(int value) {
        return BlockLabel.getTargetOf(this.getTargetLabelForValue(value));
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.switchValue : (Value)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public int getSuccessorCount() {
        return 1 + this.targetLabels.length;
    }

    @Override
    public BasicBlock getSuccessor(int index) {
        int len = this.targetLabels.length;
        return index < len ? this.getTargetForIndex(index) : (index == len ? this.getDefaultTarget() : (BasicBlock)Util.throwIndexOutOfBounds(index));
    }

    public float getDensity() {
        int numVals = this.values.length;
        if (numVals == 0) {
            return 0.0f;
        }
        float valueRange = this.values[numVals - 1] - this.values[0] + 1;
        return (float)numVals / valueRange;
    }

    @Override
    public <T, R> R accept(TerminatorVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    int calcHashCode() {
        return (Objects.hash(this.dependency, this.defaultTargetLabel, this.switchValue) * 19 + Arrays.hashCode(this.values)) * 19 + Arrays.hashCode(this.targetLabels);
    }

    @Override
    String getNodeName() {
        return "Switch";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Switch && this.equals((Switch)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.switchValue.toReferenceString(b);
        b.append(')');
        return b;
    }

    public boolean equals(Switch other) {
        return this == other || other != null && this.hashCode() == other.hashCode() && this.dependency.equals(other.dependency) && this.defaultTargetLabel.equals(other.defaultTargetLabel) && this.switchValue.equals(other.switchValue) && Arrays.equals(this.values, other.values) && Arrays.equals(this.targetLabels, other.targetLabels);
    }
}

