/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.PointerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class StackAllocation
extends AbstractValue
implements OrderedNode {
    private final Node dependency;
    private final ValueType type;
    private final Value count;
    private final Value align;

    StackAllocation(Node callSite, ExecutableElement element, int line, int bci, Node dependency, ValueType type, Value count, Value align) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.type = type;
        this.count = count;
        this.align = align;
    }

    @Override
    int calcHashCode() {
        return System.identityHashCode(this);
    }

    @Override
    String getNodeName() {
        return "StackAllocation";
    }

    @Override
    public boolean equals(Object other) {
        return other == this;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.type.toString(b);
        b.append(',');
        this.count.toReferenceString(b);
        b.append(',');
        this.align.toReferenceString(b);
        b.append(')');
        return b;
    }

    @Override
    public PointerType getType() {
        return this.type.getPointer();
    }

    public Value getCount() {
        return this.count;
    }

    public Value getAlign() {
        return this.align;
    }

    @Override
    public int getValueDependencyCount() {
        return 2;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.count : (index == 1 ? this.align : (Value)Util.throwIndexOutOfBounds(index));
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }
}

