/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import io.smallrye.common.constraint.Assert;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class Slot
implements Comparable<Slot> {
    private static final ConcurrentHashMap<String, Slot[]> cache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, List<Slot>> simpleArgListCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<List<Slot>, List<Slot>> addingThreadCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<List<Slot>, List<Slot>> addingThisCache = new ConcurrentHashMap();
    private static final Slot THREAD = new Slot("thr", 0);
    private static final Slot THIS = new Slot("this", 1);
    private static final Slot RESULT = new Slot("result", 3);
    private static final Slot THROWN = new Slot("thrown", 4);
    private final String name;
    private final int sortOrder;
    private final int index;

    Slot(String name, int sortOrder) {
        this.name = name;
        this.sortOrder = sortOrder;
        this.index = -1;
    }

    Slot(String name, int sortOrder, int index) {
        Assert.checkMinimumParameter((String)"index", (int)0, (int)index);
        Assert.checkMaximumParameter((String)"index", (int)65535, (int)index);
        this.name = name;
        this.sortOrder = sortOrder;
        this.index = index;
    }

    @Override
    public int compareTo(Slot other) {
        int res = Integer.compare(this.sortOrder, other.sortOrder);
        if (res == 0) {
            res = Integer.compare(this.index, other.index);
        }
        return res;
    }

    public StringBuilder toString(StringBuilder b) {
        b.append(this.name);
        if (this.index != -1) {
            b.append(this.index);
        }
        return b;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        int index = this.index;
        return index == -1 ? 0 : index;
    }

    static Slot get(String name, int sortOrder, int index) {
        Slot[] oldVal = cache.get(name);
        while (true) {
            Slot[] newVal;
            if (oldVal == null) {
                oldLen = 0;
                newVal = new Slot[index + 1];
            } else {
                oldLen = oldVal.length;
                if (oldLen > index) {
                    return oldVal[index];
                }
                newVal = Arrays.copyOf(oldVal, index + 1);
            }
            for (int i = oldLen; i <= index; ++i) {
                newVal[i] = new Slot(name, sortOrder, i);
            }
            if (oldVal == null) {
                Slot[] appearing = cache.putIfAbsent(name, newVal);
                if (appearing != null) {
                    oldVal = appearing;
                    continue;
                }
                return newVal[index];
            }
            if (cache.replace(name, oldVal, newVal)) {
                return newVal[index];
            }
            oldVal = cache.get(name);
        }
    }

    public static Slot funcParam(int n) {
        return Slot.get("p", 2, n);
    }

    public static Slot stack(int n) {
        return Slot.get("stack", 5, n);
    }

    public static Slot temp(int n) {
        return Slot.get("tmp", 7, n);
    }

    public static Slot variable(int n) {
        return Slot.get("var", 6, n);
    }

    public static Slot result() {
        return RESULT;
    }

    public static Slot this_() {
        return THIS;
    }

    public static Slot thread() {
        return THREAD;
    }

    public static Slot thrown() {
        return THROWN;
    }

    public static List<Slot> simpleArgList(int cnt) {
        List<Slot> appearing;
        Assert.checkMinimumParameter((String)"cnt", (int)0, (int)cnt);
        Assert.checkMaximumParameter((String)"cnt", (int)65535, (int)cnt);
        if (cnt == 0) {
            return List.of();
        }
        Integer boxed = cnt;
        List<Slot> list = simpleArgListCache.get(boxed);
        if (list == null && (appearing = simpleArgListCache.putIfAbsent(boxed, list = IntStream.range(0, cnt).mapToObj(Slot::funcParam).toList())) != null) {
            list = appearing;
        }
        return list;
    }

    public static List<Slot> argListWithPrependedThis(List<Slot> original) {
        List<Slot> appearing;
        Assert.checkNotNullParam((String)"original", original);
        List<Slot> list = addingThisCache.get(original);
        if (list == null && (appearing = addingThisCache.putIfAbsent(original, list = Stream.concat(Stream.of(Slot.this_()), original.stream()).toList())) != null) {
            list = appearing;
        }
        return list;
    }

    public static List<Slot> argListWithPrependedThread(List<Slot> original) {
        List<Slot> appearing;
        Assert.checkNotNullParam((String)"original", original);
        List<Slot> list = addingThreadCache.get(original);
        if (list == null && (appearing = addingThreadCache.putIfAbsent(original, list = Stream.concat(Stream.of(Slot.thread()), original.stream()).toList())) != null) {
            list = appearing;
        }
        return list;
    }
}

