/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractTerminator;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.Node;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.type.definition.element.ExecutableElement;

public final class Return
extends AbstractTerminator
implements Terminator {
    private final Node dependency;
    private final Value returnValue;
    private final BasicBlock terminatedBlock;

    Return(Node callSite, ExecutableElement element, int line, int bci, BlockEntry blockEntry, Node dependency, Value returnValue) {
        super(callSite, element, line, bci);
        this.terminatedBlock = new BasicBlock(blockEntry, this);
        this.dependency = dependency;
        this.returnValue = returnValue;
    }

    @Override
    public BasicBlock getTerminatedBlock() {
        return this.terminatedBlock;
    }

    public Value getReturnValue() {
        return this.returnValue;
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.getReturnValue() : (Value)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public <T, R> R accept(TerminatorVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    int calcHashCode() {
        return Objects.hash(Return.class, this.dependency, this.returnValue);
    }

    @Override
    String getNodeName() {
        return "Return";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Return && this.equals((Return)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.returnValue.toReferenceString(b);
        b.append(')');
        return b;
    }

    public boolean equals(Return other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.returnValue.equals(other.returnValue);
    }
}

