/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractNode;
import org.qbicc.graph.Action;
import org.qbicc.graph.ActionVisitor;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.type.definition.element.ExecutableElement;

public final class Reachable
extends AbstractNode
implements Action,
OrderedNode {
    private final Node dependency;
    private final Value reachableValue;

    Reachable(Node callSite, ExecutableElement element, int line, int bci, Node dependency, Value reachableValue) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.reachableValue = reachableValue;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return switch (index) {
            case 0 -> this.reachableValue;
            default -> (Value)Util.throwIndexOutOfBounds(index);
        };
    }

    public Value getReachableValue() {
        return this.reachableValue;
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    String getNodeName() {
        return "Reachable";
    }

    @Override
    int calcHashCode() {
        return Objects.hash(Reachable.class, this.dependency, this.reachableValue);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.reachableValue.toReferenceString(super.toString(b).append('(')).append(')');
    }

    @Override
    public boolean equals(Object other) {
        Reachable r;
        return other instanceof Reachable && this.equals(r = (Reachable)other);
    }

    public boolean equals(Reachable other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.reachableValue.equals(other.reachableValue);
    }

    @Override
    public <T, R> R accept(ActionVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

