/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.PrimitiveArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class NewArray
extends AbstractValue
implements OrderedNode {
    private final Node dependency;
    private final PrimitiveArrayObjectType type;
    private final Value size;

    NewArray(Node callSite, ExecutableElement element, int line, int bci, Node dependency, PrimitiveArrayObjectType type, Value size) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.type = type;
        this.size = size;
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public boolean maySafePoint() {
        return true;
    }

    @Override
    public ReferenceType getType() {
        return this.type.getReference();
    }

    public Value getSize() {
        return this.size;
    }

    public ValueType getElementType() {
        return this.type.getElementType();
    }

    public PrimitiveArrayObjectType getArrayType() {
        return this.type;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.size : (Value)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    int calcHashCode() {
        return System.identityHashCode(this);
    }

    @Override
    String getNodeName() {
        return "NewArray";
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.type.toString(b);
        b.append(',');
        this.size.toReferenceString(b);
        b.append(')');
        return b;
    }

    @Override
    public boolean isNullable() {
        return false;
    }
}

