/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.literal.NullLiteral;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class New
extends AbstractValue
implements OrderedNode {
    private final Node dependency;
    private final ClassObjectType type;
    private final Value typeId;
    private final Value size;
    private final Value align;

    New(Node callSite, ExecutableElement element, int line, int bci, Node dependency, ClassObjectType type, Value typeId, Value size, Value align) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.type = type;
        this.typeId = typeId;
        this.size = size;
        this.align = align;
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public boolean maySafePoint() {
        return true;
    }

    @Override
    public int getValueDependencyCount() {
        return 3;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        switch (index) {
            case 0: {
                return this.typeId;
            }
            case 1: {
                return this.size;
            }
            case 2: {
                return this.align;
            }
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    public ReferenceType getType() {
        return this.type.getReference();
    }

    public Value getTypeId() {
        return this.typeId;
    }

    public Value getSize() {
        return this.size;
    }

    public Value getAlign() {
        return this.align;
    }

    public ClassObjectType getClassObjectType() {
        return this.type;
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    int calcHashCode() {
        return System.identityHashCode(this);
    }

    @Override
    String getNodeName() {
        return "New";
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.type.toString(b);
        b.append(',');
        this.typeId.toReferenceString(b);
        b.append(',');
        this.size.toReferenceString(b);
        b.append(',');
        this.align.toReferenceString(b);
        b.append(')');
        return b;
    }

    @Override
    public boolean isDefNe(Value other) {
        return other instanceof NullLiteral;
    }

    @Override
    public boolean isNullable() {
        return false;
    }
}

