/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.List;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class MultiNewArray
extends AbstractValue
implements OrderedNode {
    private final Node dependency;
    private final ArrayObjectType type;
    private final List<Value> dimensions;

    MultiNewArray(Node callSite, ExecutableElement element, int line, int bci, Node dependency, ArrayObjectType type, List<Value> dimensions) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.type = type;
        this.dimensions = dimensions;
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public boolean maySafePoint() {
        return true;
    }

    @Override
    public ReferenceType getType() {
        return this.type.getReference();
    }

    public List<Value> getDimensions() {
        return this.dimensions;
    }

    public ValueType getElementType() {
        return this.type.getElementType();
    }

    public ArrayObjectType getArrayType() {
        return this.type;
    }

    @Override
    public int getValueDependencyCount() {
        return this.dimensions.size();
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return this.dimensions.get(index);
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    int calcHashCode() {
        return System.identityHashCode(this);
    }

    @Override
    String getNodeName() {
        return "MultiNewArray";
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.type.toString(b);
        for (Value dimension : this.dimensions) {
            b.append(',');
            dimension.toReferenceString(b);
        }
        b.append(')');
        return b;
    }
}

