/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.atomic.AccessMode;
import org.qbicc.type.CompoundType;
import org.qbicc.type.PointerType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class MemberOf
extends AbstractValue {
    private final Value structurePointer;
    private final PointerType pointerType;
    private final CompoundType.Member member;

    MemberOf(Node callSite, ExecutableElement element, int line, int bci, Value structurePointer, CompoundType.Member member) {
        super(callSite, element, line, bci);
        this.structurePointer = structurePointer;
        this.member = member;
        this.pointerType = member.getType().getPointer().withQualifiersFrom(structurePointer.getType(PointerType.class));
    }

    public CompoundType getStructType() {
        return this.getStructurePointer().getType(PointerType.class).getPointeeType(CompoundType.class);
    }

    @Override
    public PointerType getType() {
        return this.pointerType;
    }

    @Override
    public boolean isConstant() {
        return this.structurePointer.isConstant();
    }

    @Override
    public boolean isPointeeConstant() {
        return this.structurePointer.isPointeeConstant();
    }

    @Override
    public AccessMode getDetectedMode() {
        return this.structurePointer.getDetectedMode();
    }

    public CompoundType.Member getMember() {
        return this.member;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        switch (index) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(index);
            }
        }
        return this.structurePointer;
    }

    public Value getStructurePointer() {
        return this.structurePointer;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.structurePointer, this.member);
    }

    @Override
    String getNodeName() {
        return "MemberOf";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof MemberOf && this.equals((MemberOf)other);
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        b.append("member pointer ");
        this.structurePointer.toReferenceString(b);
        b.append('.');
        this.member.toString(b);
        return b;
    }

    public boolean equals(MemberOf other) {
        return this == other || other != null && this.structurePointer.equals(other.structurePointer) && this.member.equals(other.member);
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

