/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public class Load
extends AbstractValue
implements OrderedNode {
    private final Node dependency;
    private final Value pointer;
    private final ReadAccessMode mode;

    Load(Node callSite, ExecutableElement element, int line, int bci, Node dependency, Value pointer, ReadAccessMode mode) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.pointer = pointer;
        this.mode = mode;
        if (!pointer.isReadable()) {
            throw new IllegalArgumentException("Pointer is not readable");
        }
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.dependency, this.pointer, this.mode);
    }

    @Override
    String getNodeName() {
        return "Load";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Load && this.equals((Load)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return super.toString(b).append('(').append(this.mode).append(')');
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        return this.pointer.toReferenceString(b.append("load ").append(this.mode).append(" from "));
    }

    public boolean equals(Load other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.pointer.equals(other.pointer) && this.mode == other.mode;
    }

    @Override
    public ValueType getType() {
        return this.pointer.getPointeeType();
    }

    public Value getPointer() {
        return this.pointer;
    }

    public ReadAccessMode getAccessMode() {
        return this.mode;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        switch (index) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(index);
            }
        }
        return this.pointer;
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public boolean isConstant() {
        return this.pointer.isPointeeConstant();
    }
}

