/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.qbicc.graph.AbstractTerminator;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.InvocationNode;
import org.qbicc.graph.Node;
import org.qbicc.graph.Slot;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.type.InvokableType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class InvokeNoReturn
extends AbstractTerminator
implements InvocationNode {
    private final Node dependency;
    private final BasicBlock terminatedBlock;
    private final Value target;
    private final Value receiver;
    private final List<Value> arguments;
    private final InvokableType calleeType;
    private final BlockLabel catchLabel;

    InvokeNoReturn(Node callSite, ExecutableElement element, int line, int bci, BlockEntry blockEntry, Node dependency, Value target, Value receiver, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        super(callSite, element, line, bci, targetArguments);
        this.dependency = dependency;
        this.terminatedBlock = new BasicBlock(blockEntry, this);
        this.target = target;
        this.receiver = receiver;
        this.arguments = arguments;
        this.catchLabel = catchLabel;
        this.calleeType = (InvokableType)target.getPointeeType();
    }

    @Override
    int calcHashCode() {
        return Objects.hash(InvokeNoReturn.class, this.dependency, this.target, this.receiver, this.arguments);
    }

    @Override
    String getNodeName() {
        return "InvokeNoReturn";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof InvokeNoReturn && this.equals((InvokeNoReturn)other);
    }

    public boolean equals(InvokeNoReturn other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.target.equals(other.target) && this.receiver.equals(other.receiver) && this.arguments.equals(other.arguments);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return InvocationNode.toRValueString(this, "invoke", b).append(" no-return catch ").append(this.catchLabel);
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public boolean maySafePoint() {
        return !this.target.isNoSafePoints();
    }

    @Override
    public InvokableType getCalleeType() {
        return this.calleeType;
    }

    @Override
    public List<Value> getArguments() {
        return this.arguments;
    }

    @Override
    public Value getTarget() {
        return this.target;
    }

    @Override
    public Value getReceiver() {
        return this.receiver;
    }

    @Override
    public BasicBlock getTerminatedBlock() {
        return this.terminatedBlock;
    }

    public BlockLabel getCatchLabel() {
        return this.catchLabel;
    }

    public BasicBlock getCatchBlock() {
        return BlockLabel.getTargetOf(this.catchLabel);
    }

    @Override
    public int getSuccessorCount() {
        return 1;
    }

    @Override
    public BasicBlock getSuccessor(int index) {
        return index == 0 ? this.getCatchBlock() : (BasicBlock)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public boolean isImplicitOutboundArgument(Slot slot, BasicBlock block) {
        return slot == Slot.thrown() && block == this.getCatchBlock();
    }

    @Override
    public <T, R> R accept(TerminatorVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

