/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.qbicc.graph.AbstractTerminator;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.InvocationNode;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.PinnedNode;
import org.qbicc.graph.Resume;
import org.qbicc.graph.Slot;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.InvokableType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class Invoke
extends AbstractTerminator
implements Resume,
InvocationNode {
    private final Node dependency;
    private final BasicBlock terminatedBlock;
    private final Value target;
    private final Value receiver;
    private final List<Value> arguments;
    private final InvokableType calleeType;
    private final BlockLabel catchLabel;
    private final BlockLabel resumeLabel;
    private final ReturnValue returnValue;

    Invoke(Node callSite, ExecutableElement element, int line, int bci, BlockEntry blockEntry, Node dependency, Value target, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        super(callSite, element, line, bci, targetArguments);
        this.dependency = dependency;
        this.terminatedBlock = new BasicBlock(blockEntry, this);
        this.target = target;
        this.receiver = receiver;
        this.arguments = arguments;
        this.catchLabel = catchLabel;
        this.resumeLabel = resumeLabel;
        this.calleeType = (InvokableType)target.getPointeeType();
        this.returnValue = new ReturnValue();
    }

    @Override
    int calcHashCode() {
        return Objects.hash(Invoke.class, this.dependency, this.target, this.receiver, this.arguments);
    }

    @Override
    String getNodeName() {
        return "Invoke";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Invoke && this.equals((Invoke)other);
    }

    public boolean equals(Invoke other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.target.equals(other.target) && this.receiver.equals(other.receiver) && this.arguments.equals(other.arguments);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return InvocationNode.toRValueString(this, "invoke", b).append(" catch ").append(this.catchLabel).append(" resume ").append(this.resumeLabel);
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public boolean maySafePoint() {
        return !this.target.isNoSafePoints();
    }

    @Override
    public InvokableType getCalleeType() {
        return this.calleeType;
    }

    public ReturnValue getReturnValue() {
        return this.returnValue;
    }

    @Override
    public List<Value> getArguments() {
        return this.arguments;
    }

    @Override
    public Value getTarget() {
        return this.target;
    }

    @Override
    public Value getReceiver() {
        return this.receiver;
    }

    @Override
    public BasicBlock getTerminatedBlock() {
        return this.terminatedBlock;
    }

    public BlockLabel getCatchLabel() {
        return this.catchLabel;
    }

    public BasicBlock getCatchBlock() {
        return BlockLabel.getTargetOf(this.catchLabel);
    }

    @Override
    public int getSuccessorCount() {
        return 2;
    }

    @Override
    public BasicBlock getSuccessor(int index) {
        return index == 0 ? this.getResumeTarget() : (index == 1 ? this.getCatchBlock() : (BasicBlock)Util.throwIndexOutOfBounds(index));
    }

    @Override
    public boolean isImplicitOutboundArgument(Slot slot, BasicBlock block) {
        return slot == Slot.thrown() && block == this.getCatchBlock() || slot == Slot.result() && block == this.getResumeTarget();
    }

    @Override
    public <T, R> R accept(TerminatorVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public BlockLabel getResumeTargetLabel() {
        return this.resumeLabel;
    }

    public final class ReturnValue
    extends AbstractValue
    implements PinnedNode,
    OrderedNode {
        ReturnValue() {
            super(Invoke.this.getCallSite(), Invoke.this.getElement(), Invoke.this.getSourceLine(), Invoke.this.getBytecodeIndex());
        }

        @Override
        int calcHashCode() {
            return Invoke.this.hashCode();
        }

        @Override
        String getNodeName() {
            return "ReturnValue";
        }

        public Invoke getInvoke() {
            return Invoke.this;
        }

        @Override
        public ValueType getType() {
            return Invoke.this.getCalleeType().getReturnType();
        }

        @Override
        public BlockLabel getPinnedBlockLabel() {
            return Invoke.this.resumeLabel;
        }

        @Override
        public Node getDependency() {
            return this.getPinnedBlock().getBlockEntry();
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof ReturnValue && this.equals((ReturnValue)other);
        }

        @Override
        public int getScheduleIndex() {
            return Invoke.this.getScheduleIndex();
        }

        @Override
        public BasicBlock getScheduledBlock() {
            return Invoke.this.getScheduledBlock();
        }

        @Override
        public StringBuilder toString(StringBuilder b) {
            super.toString(b);
            b.append(" of ");
            Invoke.this.toString(b);
            return b;
        }

        public boolean equals(ReturnValue other) {
            return this == other || other != null && this.getInvoke().equals(other.getInvoke());
        }

        @Override
        public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
            return visitor.visit(param, this);
        }
    }
}

