/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BooleanValue;
import org.qbicc.graph.InstanceOperation;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.BooleanType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class InstanceOf
extends AbstractValue
implements InstanceOperation,
OrderedNode,
BooleanValue {
    private final Node dependency;
    private final Value input;
    private final Value valueIfTrue;
    private final ObjectType checkType;
    private final int checkDimensions;
    private final BooleanType booleanType;

    InstanceOf(Node callSite, ExecutableElement element, int line, int bci, Node dependency, Value input, Value valueIfTrue, ObjectType checkType, int checkDimensions, BooleanType booleanType) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.input = input;
        this.valueIfTrue = valueIfTrue;
        this.checkType = checkType;
        this.checkDimensions = checkDimensions;
        this.booleanType = booleanType;
    }

    public ObjectType getCheckType() {
        return this.checkType;
    }

    public int getCheckDimensions() {
        return this.checkDimensions;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.dependency, this.input, this.checkType) * 31 + this.checkDimensions;
    }

    @Override
    String getNodeName() {
        return "InstanceOf";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof InstanceOf && this.equals((InstanceOf)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.input.toReferenceString(b);
        b.append(',');
        this.checkType.toString(b);
        b.append(',');
        b.append(this.checkDimensions);
        b.append(')');
        return b;
    }

    public boolean equals(InstanceOf other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.input.equals(other.input) && this.checkType.equals(other.checkType) && this.checkDimensions == other.checkDimensions;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.input : (Value)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public Value getInstance() {
        return this.input;
    }

    @Override
    public BooleanType getType() {
        return this.booleanType;
    }

    @Override
    public Value getValueIfTrue(BasicBlockBuilder bbb, Value input) {
        return input.equals(this.input) ? this.valueIfTrue : super.getValueIfTrue(bbb, input);
    }

    @Override
    public Value getValueIfFalse(BasicBlockBuilder bbb, Value input) {
        return input;
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public boolean isConstant() {
        return this.input.isConstant();
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }
}

