/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.type.CompoundType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class InsertMember
extends AbstractValue {
    private final Value compoundValue;
    private final Value insertedValue;
    private final CompoundType compoundType;
    private final CompoundType.Member member;

    InsertMember(Node callSite, ExecutableElement element, int line, int bci, Value compoundValue, Value insertedValue, CompoundType.Member member) {
        super(callSite, element, line, bci);
        this.compoundValue = compoundValue;
        this.insertedValue = insertedValue;
        this.compoundType = (CompoundType)compoundValue.getType();
        this.member = member;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.compoundValue, this.insertedValue, this.member);
    }

    @Override
    String getNodeName() {
        return "InsertMember";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof InsertMember && this.equals((InsertMember)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.compoundValue.toReferenceString(b);
        b.append(',');
        this.member.toString(b);
        b.append(',');
        this.insertedValue.toReferenceString(b);
        b.append(')');
        return b;
    }

    public boolean equals(InsertMember other) {
        return this == other || other != null && this.compoundValue.equals(other.compoundValue) && this.insertedValue.equals(other.insertedValue) && this.member.equals(other.member);
    }

    public Value getCompoundValue() {
        return this.compoundValue;
    }

    public Value getInsertedValue() {
        return this.insertedValue;
    }

    @Override
    public CompoundType getType() {
        return this.compoundType;
    }

    public CompoundType.Member getMember() {
        return this.member;
    }

    @Override
    public int getValueDependencyCount() {
        return 2;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.compoundValue : (index == 1 ? this.insertedValue : (Value)Util.throwIndexOutOfBounds(index));
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public Value extractMember(LiteralFactory lf, CompoundType.Member member) {
        return member.equals(this.member) ? this.insertedValue : this.compoundValue.extractMember(lf, member);
    }

    @Override
    public boolean isConstant() {
        return this.compoundValue.isConstant() && this.insertedValue.isConstant();
    }
}

