/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.type.ArrayType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class InsertElement
extends AbstractValue {
    private final Value arrayValue;
    private final ArrayType arrayType;
    private final Value index;
    private final Value insertedValue;

    InsertElement(Node callSite, ExecutableElement element, int line, int bci, Value arrayValue, Value index, Value insertedValue) {
        super(callSite, element, line, bci);
        this.arrayValue = arrayValue;
        this.arrayType = (ArrayType)arrayValue.getType();
        this.index = index;
        this.insertedValue = insertedValue;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.arrayValue, this.index, this.insertedValue);
    }

    @Override
    String getNodeName() {
        return "InsertElement";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof InsertElement && this.equals((InsertElement)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.arrayValue.toReferenceString(b);
        b.append(',');
        this.index.toReferenceString(b);
        b.append(',');
        this.insertedValue.toReferenceString(b);
        b.append(')');
        return b;
    }

    public boolean equals(InsertElement other) {
        return this == other || other != null && this.arrayValue.equals(other.arrayValue) && this.index.equals(other.index) && this.insertedValue.equals(other.insertedValue);
    }

    public Value getArrayValue() {
        return this.arrayValue;
    }

    public Value getIndex() {
        return this.index;
    }

    public Value getInsertedValue() {
        return this.insertedValue;
    }

    @Override
    public ArrayType getType() {
        return this.arrayType;
    }

    @Override
    public int getValueDependencyCount() {
        return 3;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.arrayValue : (index == 1 ? this.index : (index == 2 ? this.insertedValue : (Value)Util.throwIndexOutOfBounds(index)));
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public Value extractElement(LiteralFactory lf, Value index) {
        return index.equals(this.index) ? this.insertedValue : this.arrayValue.extractElement(lf, index);
    }

    @Override
    public boolean isConstant() {
        return this.arrayValue.isConstant() && this.index.isConstant() && this.insertedValue.isConstant();
    }
}

