/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractNode;
import org.qbicc.graph.Action;
import org.qbicc.graph.ActionVisitor;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.type.definition.element.ExecutableElement;

public final class InitializeClass
extends AbstractNode
implements Action,
OrderedNode {
    private final Node dependency;
    private final Value classToInitialize;

    InitializeClass(Node callSite, ExecutableElement element, int line, int bci, Node dependency, Value classToInitialize) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.classToInitialize = classToInitialize;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return switch (index) {
            case 0 -> this.classToInitialize;
            default -> (Value)Util.throwIndexOutOfBounds(index);
        };
    }

    public Value getInitializeClassValue() {
        return this.classToInitialize;
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    String getNodeName() {
        return "InitializeClass";
    }

    @Override
    int calcHashCode() {
        return Objects.hash(InitializeClass.class, this.dependency, this.classToInitialize);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.classToInitialize.toReferenceString(super.toString(b).append('(')).append(')');
    }

    @Override
    public boolean equals(Object other) {
        InitializeClass r;
        return other instanceof InitializeClass && this.equals(r = (InitializeClass)other);
    }

    public boolean equals(InitializeClass other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.classToInitialize.equals(other.classToInitialize);
    }

    @Override
    public <T, R> R accept(ActionVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

