/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Map;
import java.util.Objects;
import org.qbicc.graph.AbstractTerminator;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.Node;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.type.definition.element.ExecutableElement;

public final class If
extends AbstractTerminator
implements Terminator {
    private final Node dependency;
    private final Value condition;
    private final BlockLabel trueBranchLabel;
    private final BlockLabel falseBranchLabel;
    private final BasicBlock terminatedBlock;

    If(Node callSite, ExecutableElement element, int line, int bci, BlockEntry blockEntry, Node dependency, Value condition, BlockLabel trueBranchLabel, BlockLabel falseBranchLabel, Map<Slot, Value> blockArgs) {
        super(callSite, element, line, bci, blockArgs);
        this.terminatedBlock = new BasicBlock(blockEntry, this);
        this.dependency = dependency;
        this.condition = condition;
        this.trueBranchLabel = trueBranchLabel;
        this.falseBranchLabel = falseBranchLabel;
    }

    @Override
    public BasicBlock getTerminatedBlock() {
        return this.terminatedBlock;
    }

    public final Value getCondition() {
        return this.condition;
    }

    public BlockLabel getTrueBranchLabel() {
        return this.trueBranchLabel;
    }

    public BasicBlock getTrueBranch() {
        return BlockLabel.getTargetOf(this.trueBranchLabel);
    }

    public BlockLabel getFalseBranchLabel() {
        return this.falseBranchLabel;
    }

    public BasicBlock getFalseBranch() {
        return BlockLabel.getTargetOf(this.falseBranchLabel);
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.getCondition() : (Value)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public int getSuccessorCount() {
        return 2;
    }

    @Override
    public BasicBlock getSuccessor(int index) {
        return index == 0 ? this.getTrueBranch() : (index == 1 ? this.getFalseBranch() : (BasicBlock)Util.throwIndexOutOfBounds(index));
    }

    @Override
    public <T, R> R accept(TerminatorVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    int calcHashCode() {
        return Objects.hash(If.class, this.dependency, this.condition, this.trueBranchLabel, this.falseBranchLabel);
    }

    @Override
    String getNodeName() {
        return "If";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof If && this.equals((If)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.condition.toReferenceString(b);
        b.append(')');
        if (this.trueBranchLabel.hasTarget() && this.falseBranchLabel.hasTarget()) {
            b.append(' ');
            b.append("then");
            b.append(' ');
            this.getTrueBranch().toString(b);
            b.append(' ');
            b.append("else");
            b.append(' ');
            this.getFalseBranch().toString(b);
        }
        return b;
    }

    public boolean equals(If other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.condition.equals(other.condition) && this.trueBranchLabel.equals(other.trueBranchLabel) && this.falseBranchLabel.equals(other.falseBranchLabel);
    }
}

