/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.CompoundType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class ExtractMember
extends AbstractValue {
    private final Value compoundValue;
    private final CompoundType compoundType;
    private final CompoundType.Member member;

    ExtractMember(Node callSite, ExecutableElement element, int line, int bci, Value compoundValue, CompoundType.Member member) {
        super(callSite, element, line, bci);
        this.compoundValue = compoundValue;
        this.compoundType = (CompoundType)compoundValue.getType();
        this.member = member;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.compoundValue, this.member);
    }

    @Override
    String getNodeName() {
        return "ExtractMember";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ExtractMember && this.equals((ExtractMember)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.compoundValue.toReferenceString(b);
        b.append(',');
        this.member.toString(b);
        b.append(')');
        return b;
    }

    public boolean equals(ExtractMember other) {
        return this == other || other != null && this.compoundValue.equals(other.compoundValue) && this.member.equals(other.member);
    }

    public CompoundType getCompoundType() {
        return this.compoundType;
    }

    public Value getCompoundValue() {
        return this.compoundValue;
    }

    @Override
    public ValueType getType() {
        return this.member.getType();
    }

    public CompoundType.Member getMember() {
        return this.member;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.compoundValue : (Value)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public boolean isConstant() {
        return this.compoundValue.isConstant();
    }
}

