/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.ArrayType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class ExtractElement
extends AbstractValue {
    private final Value arrayValue;
    private final ArrayType arrayType;
    private final Value index;

    ExtractElement(Node callSite, ExecutableElement element, int line, int bci, Value arrayValue, Value index) {
        super(callSite, element, line, bci);
        this.arrayValue = arrayValue;
        this.arrayType = (ArrayType)arrayValue.getType();
        this.index = index;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.arrayValue, this.index);
    }

    @Override
    String getNodeName() {
        return "ExtractElement";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ExtractElement && this.equals((ExtractElement)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.arrayValue.toReferenceString(b);
        b.append(',');
        this.index.toReferenceString(b);
        b.append(')');
        return b;
    }

    public boolean equals(ExtractElement other) {
        return this == other || other != null && this.arrayValue.equals(other.arrayValue) && this.index.equals(other.index);
    }

    public ArrayType getArrayType() {
        return this.arrayType;
    }

    public Value getArrayValue() {
        return this.arrayValue;
    }

    public Value getIndex() {
        return this.index;
    }

    @Override
    public ValueType getType() {
        return this.arrayType.getElementType();
    }

    @Override
    public int getValueDependencyCount() {
        return 2;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.arrayValue : (index == 1 ? this.index : (Value)Util.throwIndexOutOfBounds(index));
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public boolean isConstant() {
        return this.arrayValue.isConstant() && this.index.isConstant();
    }
}

