/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.atomic.AccessMode;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.ArrayType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class ElementOf
extends AbstractValue {
    private final Value arrayPointer;
    private final Value index;
    private final PointerType pointerType;

    ElementOf(Node callSite, ExecutableElement element, int line, int bci, Value arrayPointer, Value index) {
        super(callSite, element, line, bci);
        PointerType pointerType;
        this.arrayPointer = arrayPointer;
        this.index = index;
        ValueType inputType = arrayPointer.getPointeeType();
        if (inputType instanceof ArrayType) {
            pointerType = ((ArrayType)inputType).getElementType().getPointer();
        } else if (inputType instanceof ArrayObjectType) {
            pointerType = ((ArrayObjectType)inputType).getElementType().getPointer();
        } else {
            throw new IllegalArgumentException("Invalid input type: " + inputType);
        }
        this.pointerType = pointerType.withQualifiersFrom(arrayPointer.getType(PointerType.class));
    }

    @Override
    public PointerType getType() {
        return this.pointerType;
    }

    @Override
    public boolean isConstant() {
        return this.index.isConstant() && this.arrayPointer.isConstant();
    }

    @Override
    public boolean isPointeeConstant() {
        return this.index.isConstant() && this.arrayPointer.isPointeeConstant();
    }

    public Value getArrayPointer() {
        return this.arrayPointer;
    }

    public Value getIndex() {
        return this.index;
    }

    @Override
    public AccessMode getDetectedMode() {
        return this.arrayPointer.getDetectedMode();
    }

    @Override
    public int getValueDependencyCount() {
        return 2;
    }

    @Override
    public Value getValueDependency(int idx) throws IndexOutOfBoundsException {
        return switch (idx) {
            case 0 -> this.arrayPointer;
            case 1 -> this.index;
            default -> throw new IndexOutOfBoundsException(idx);
        };
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.arrayPointer, this.index);
    }

    @Override
    String getNodeName() {
        return "ElementOf";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ElementOf && this.equals((ElementOf)other);
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        b.append("element pointer ");
        this.arrayPointer.toReferenceString(b);
        b.append('[');
        this.index.toString(b);
        b.append(']');
        return b;
    }

    public boolean equals(ElementOf other) {
        return this == other || other != null && this.arrayPointer.equals(other.arrayPointer) && this.index.equals(other.index);
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

