/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class Dereference
extends AbstractValue {
    private final Value pointer;

    Dereference(Node callSite, ExecutableElement element, int line, int bci, Value pointer) {
        super(callSite, element, line, bci);
        this.pointer = pointer;
    }

    public Value getPointer() {
        return this.pointer;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        switch (index) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(index);
            }
        }
        return this.pointer;
    }

    @Override
    public ValueType getType() {
        return this.pointer.getPointeeType();
    }

    @Override
    int calcHashCode() {
        return Objects.hash(Dereference.class, this.pointer);
    }

    @Override
    String getNodeName() {
        return "Dereference";
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        return this.pointer.toReferenceString(b.append("deref "));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Dereference && this.equals((Dereference)other);
    }

    public boolean equals(Dereference other) {
        return this == other || other != null && this.pointer.equals(other.pointer);
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

